/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.tasks.dependencies;

import io.sentry.android.gradle.tasks.DirectoryOutputTask;
import io.sentry.android.gradle.util.ArtifactsKt;
import io.sentry.android.gradle.util.GradleVersions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/sentry/android/gradle/tasks/dependencies/SentryExternalDependenciesReportTask;", "Lio/sentry/android/gradle/tasks/DirectoryOutputTask;", "()V", "attributeValueJar", "Lorg/gradle/api/provider/Property;", "", "getAttributeValueJar", "()Lorg/gradle/api/provider/Property;", "includeReport", "", "getIncludeReport", "runtimeConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "action", "", "getRuntimeClasspath", "Lorg/gradle/api/file/FileCollection;", "setRuntimeConfiguration", "configuration", "Companion", "sentry-android-gradle-plugin"})
public abstract class SentryExternalDependenciesReportTask
extends DirectoryOutputTask {
    private transient Configuration runtimeConfiguration;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Input
    @NotNull
    public abstract Property<Boolean> getIncludeReport();

    public final void setRuntimeConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.runtimeConfiguration = configuration;
    }

    @Input
    @NotNull
    public abstract Property<String> getAttributeValueJar();

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @NotNull
    public final FileCollection getRuntimeClasspath() {
        Configuration configuration = this.runtimeConfiguration;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeConfiguration");
        }
        Object object = this.getAttributeValueJar().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attributeValueJar.get()");
        ArtifactCollection artifactCollection = ArtifactsKt.artifactsFor(configuration, (String)object);
        Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"runtimeConfiguration.art\u2026ibuteValueJar.get()\n    )");
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"runtimeConfiguration.art\u2026get()\n    ).artifactFiles");
        return fileCollection;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        void $this$mapTo$iv$iv;
        ResolvedComponentResult it;
        Iterable $this$filterTo$iv$iv;
        Object object = this.getOutput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"output.get()");
        File outputDir = ((Directory)object).getAsFile();
        outputDir.mkdirs();
        Configuration configuration = this.runtimeConfiguration;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"runtimeConfiguration");
        }
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableDependencies, (String)"runtimeConfiguration\n            .incoming");
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkNotNullExpressionValue((Object)resolutionResult, (String)"runtimeConfiguration\n   \u2026        .resolutionResult");
        Set set = resolutionResult.getAllComponents();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"runtimeConfiguration\n   \u2026           .allComponents");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResolvedComponentResult)element$iv$iv;
            boolean bl = false;
            ResolvedComponentResult resolvedComponentResult = it;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"it");
            if (!(resolvedComponentResult.getId() instanceof ModuleComponentIdentifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CharSequence charSequence;
            it = (ResolvedComponentResult)element$iv$iv;
            boolean bl = false;
            ResolvedComponentResult resolvedComponentResult = it;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"it");
            Object object2 = resolvedComponentResult.getModuleVersion();
            if (!(object2 != null && (object2 = object2.getVersion()) != null && (charSequence = (CharSequence)object2).length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResolvedComponentResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ResolvedComponentResult resolvedComponentResult = it;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedComponentResult, (String)"it");
            ComponentIdentifier componentIdentifier = resolvedComponentResult.getId();
            Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"it.id");
            String string = componentIdentifier.getDisplayName();
            collection.add(string);
        }
        SortedSet dependencies = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
        File outputFile = new File(outputDir, "sentry-external-modules.txt");
        FilesKt.writeText$default((File)outputFile, (String)CollectionsKt.joinToString$default((Iterable)dependencies, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
    }

    public SentryExternalDependenciesReportTask() {
        this.setDescription("Generates an external dependencies report");
        if (GradleVersions.INSTANCE.getCURRENT().compareTo(GradleVersions.INSTANCE.getVERSION_7_4()) >= 0) {
            this.notCompatibleWithConfigurationCache("Cannot serialize Configurations");
        }
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = this.getIncludeReport().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"includeReport.get()");
                return (Boolean)object;
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\b\b\u0002\u0010\u0010\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Lio/sentry/android/gradle/tasks/dependencies/SentryExternalDependenciesReportTask$Companion;", "", "()V", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/sentry/android/gradle/tasks/dependencies/SentryExternalDependenciesReportTask;", "project", "Lorg/gradle/api/Project;", "configurationName", "", "attributeValueJar", "output", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "includeReport", "", "taskSuffix", "sentry-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final TaskProvider<SentryExternalDependenciesReportTask> register(@NotNull Project project, @NotNull String configurationName, @NotNull String attributeValueJar, @Nullable Provider<Directory> output, @NotNull Provider<Boolean> includeReport, @NotNull String taskSuffix) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            Intrinsics.checkNotNullParameter((Object)attributeValueJar, (String)"attributeValueJar");
            Intrinsics.checkNotNullParameter(includeReport, (String)"includeReport");
            Intrinsics.checkNotNullParameter((Object)taskSuffix, (String)"taskSuffix");
            TaskProvider taskProvider = project.getTasks().register("collectExternal" + taskSuffix + "DependenciesForSentry", SentryExternalDependenciesReportTask.class, new Action(includeReport, attributeValueJar, project, configurationName, output){
                final /* synthetic */ Provider $includeReport;
                final /* synthetic */ String $attributeValueJar;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $configurationName;
                final /* synthetic */ Provider $output;

                public final void execute(SentryExternalDependenciesReportTask task) {
                    block0: {
                        Provider provider;
                        task.getIncludeReport().set(this.$includeReport);
                        task.getAttributeValueJar().set((Object)this.$attributeValueJar);
                        Configuration configuration = this.$project.getConfigurations().getByName(this.$configurationName);
                        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ByName(configurationName)");
                        task.setRuntimeConfiguration(configuration);
                        Provider provider2 = this.$output;
                        if (provider2 == null) break block0;
                        Provider it = provider = provider2;
                        boolean bl = false;
                        task.getOutput().set(it);
                    }
                }
                {
                    this.$includeReport = provider;
                    this.$attributeValueJar = string;
                    this.$project = project;
                    this.$configurationName = string2;
                    this.$output = provider2;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.register(\n\u2026t.set(it) }\n            }");
            return taskProvider;
        }

        public static /* synthetic */ TaskProvider register$default(Companion companion, Project project, String string, String string2, Provider provider, Provider provider2, String string3, int n, Object object) {
            if ((n & 0x20) != 0) {
                string3 = "";
            }
            return companion.register(project, string, string2, (Provider<Directory>)provider, (Provider<Boolean>)provider2, string3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

