/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.sourcecontext;

import io.sentry.android.gradle.SentryPropertiesFileProvider;
import io.sentry.android.gradle.extensions.SentryPluginExtension;
import io.sentry.android.gradle.sourcecontext.BundleSourcesTask;
import io.sentry.android.gradle.sourcecontext.CollectSourcesTask;
import io.sentry.android.gradle.sourcecontext.GenerateBundleIdTask;
import io.sentry.android.gradle.telemetry.SentryTelemetryService;
import io.sentry.android.gradle.telemetry.SentryTelemetryTaskWrapperKt;
import io.sentry.android.gradle.util.PropertiesUtil;
import io.sentry.android.gradle.util.SentryCliExecKt;
import io.sentry.android.gradle.util.SentryLoggingKt;
import io.sentry.gradle.common.SentryVariant;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0%H\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020(H\u0014J\r\u0010)\u001a\u00020(H\u0000\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020(H\u0000\u00a2\u0006\u0002\b,R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0014\u0010\u001b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000bR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000bR\u0014\u0010\"\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0014\u00a8\u0006."}, d2={"Lio/sentry/android/gradle/sourcecontext/BundleSourcesTask;", "Lorg/gradle/api/tasks/Exec;", "()V", "bundleIdFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleIdFile", "()Lorg/gradle/api/file/RegularFileProperty;", "cliExecutable", "Lorg/gradle/api/provider/Property;", "", "getCliExecutable", "()Lorg/gradle/api/provider/Property;", "debug", "", "getDebug", "includeSourceContext", "getIncludeSourceContext", "output", "Lorg/gradle/api/file/DirectoryProperty;", "getOutput", "()Lorg/gradle/api/file/DirectoryProperty;", "sentryAuthToken", "getSentryAuthToken", "sentryOrganization", "getSentryOrganization", "sentryProject", "getSentryProject", "sentryProperties", "getSentryProperties", "sentryTelemetryService", "Lio/sentry/android/gradle/telemetry/SentryTelemetryService;", "getSentryTelemetryService", "sentryUrl", "getSentryUrl", "sourceDir", "getSourceDir", "computeCommandLineArgs", "", "computeCommandLineArgs$sentry_android_gradle_plugin", "exec", "", "setSentryAuthTokenEnv", "setSentryAuthTokenEnv$sentry_android_gradle_plugin", "setSentryPropertiesEnv", "setSentryPropertiesEnv$sentry_android_gradle_plugin", "Companion", "sentry-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nBundleSourcesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleSourcesTask.kt\nio/sentry/android/gradle/sourcecontext/BundleSourcesTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1#2:202\n*E\n"})
public abstract class BundleSourcesTask
extends Exec {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Input
    @NotNull
    public abstract Property<Boolean> getIncludeSourceContext();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getSourceDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getDebug();

    @Input
    @NotNull
    public abstract Property<String> getCliExecutable();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getSentryProperties();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getBundleIdFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutput();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSentryOrganization();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSentryProject();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSentryAuthToken();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSentryUrl();

    @Internal
    @NotNull
    public abstract Property<SentryTelemetryService> getSentryTelemetryService();

    protected void exec() {
        List<String> list;
        List<String> it = list = this.computeCommandLineArgs$sentry_android_gradle_plugin();
        boolean bl = false;
        this.commandLine(it);
        org.gradle.api.logging.Logger logger2 = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        SentryLoggingKt.info$default((Logger)logger2, null, (Function0)new Function0<String>(it){
            final /* synthetic */ List $it;

            @NotNull
            public final String invoke() {
                return "cli args: " + this.$it;
            }
            {
                this.$it = list;
                super(0);
            }
        }, 1, null);
        this.setSentryPropertiesEnv$sentry_android_gradle_plugin();
        this.setSentryAuthTokenEnv$sentry_android_gradle_plugin();
        super.exec();
    }

    public final void setSentryPropertiesEnv$sentry_android_gradle_plugin() {
        RegularFile sentryProperties = (RegularFile)this.getSentryProperties().getOrNull();
        if (sentryProperties != null) {
            this.environment("SENTRY_PROPERTIES", sentryProperties);
        } else {
            org.gradle.api.logging.Logger logger2 = this.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
            SentryLoggingKt.info$default((Logger)logger2, null, setSentryPropertiesEnv.1.INSTANCE, 1, null);
        }
    }

    public final void setSentryAuthTokenEnv$sentry_android_gradle_plugin() {
        String sentryAuthToken = (String)this.getSentryAuthToken().getOrNull();
        if (sentryAuthToken != null) {
            this.environment("SENTRY_AUTH_TOKEN", sentryAuthToken);
        } else {
            org.gradle.api.logging.Logger logger2 = this.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
            SentryLoggingKt.info$default((Logger)logger2, null, setSentryAuthTokenEnv.1.INSTANCE, 1, null);
        }
    }

    @NotNull
    public final List<String> computeCommandLineArgs$sentry_android_gradle_plugin() {
        Object it;
        Object object;
        Object object2;
        Object object3 = this.getBundleIdFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"bundleIdFile.get()");
        File file = ((RegularFile)object3).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"bundleIdFile.get().asFile");
        String bundleId = Companion.readBundleIdFromFile$sentry_android_gradle_plugin(file);
        List args = CollectionsKt.mutableListOf((Object[])new String[]{this.getCliExecutable().get()});
        Object object4 = this.getDebug().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"debug.getOrElse(false)");
        if (((Boolean)object4).booleanValue()) {
            args.add("--log-level=debug");
        }
        if ((object2 = (SentryTelemetryService)this.getSentryTelemetryService().getOrNull()) != null && (object2 = ((SentryTelemetryService)object2).traceCli()) != null) {
            it = object = object2;
            boolean bl = false;
            args.addAll((Collection)it);
        }
        String string = (String)this.getSentryUrl().getOrNull();
        if (string != null) {
            it = object = string;
            boolean bl = false;
            args.add("--url");
            args.add(it);
        }
        args.add("debug-files");
        args.add("bundle-jvm");
        Object object5 = this.getOutput().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"output.asFile.get()");
        args.add("--output=" + ((File)object5).getAbsolutePath());
        args.add("--debug-id=" + bundleId);
        String string2 = (String)this.getSentryOrganization().getOrNull();
        if (string2 != null) {
            it = object = string2;
            boolean bl = false;
            args.add("--org");
            args.add(it);
        }
        String string3 = (String)this.getSentryProject().getOrNull();
        if (string3 != null) {
            it = object = string3;
            boolean bl = false;
            args.add("--project");
            args.add(it);
        }
        Object object6 = this.getSourceDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"sourceDir.get()");
        File file2 = ((Directory)object6).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"sourceDir.get().asFile");
        args.add(file2.getAbsolutePath());
        return args;
    }

    public BundleSourcesTask() {
        this.setGroup("io.sentry");
        this.setDescription("Creates a Sentry source bundle file.");
        this.onlyIf(new Spec(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isSatisfiedBy(Task it) {
                Object object = this.getIncludeSourceContext().getOrElse((Object)false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"includeSourceContext.getOrElse(false)");
                if ((Boolean)object == false) return false;
                FileTree fileTree = this.getSourceDir().getAsFileTree();
                Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"sourceDir.asFileTree");
                if (fileTree.isEmpty()) return false;
                return true;
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u00ca\u0001\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\b\u0002\u0010#\u001a\u00020\u0004\u00a8\u0006$"}, d2={"Lio/sentry/android/gradle/sourcecontext/BundleSourcesTask$Companion;", "", "()V", "readBundleIdFromFile", "", "file", "Ljava/io/File;", "readBundleIdFromFile$sentry_android_gradle_plugin", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/sentry/android/gradle/sourcecontext/BundleSourcesTask;", "project", "Lorg/gradle/api/Project;", "extension", "Lio/sentry/android/gradle/extensions/SentryPluginExtension;", "sentryTelemetryProvider", "Lorg/gradle/api/provider/Provider;", "Lio/sentry/android/gradle/telemetry/SentryTelemetryService;", "variant", "Lio/sentry/gradle/common/SentryVariant;", "generateDebugIdTask", "Lio/sentry/android/gradle/sourcecontext/GenerateBundleIdTask;", "collectSourcesTask", "Lio/sentry/android/gradle/sourcecontext/CollectSourcesTask;", "output", "Lorg/gradle/api/file/Directory;", "debug", "Lorg/gradle/api/provider/Property;", "", "cliExecutable", "sentryOrg", "sentryProject", "sentryAuthToken", "sentryUrl", "includeSourceContext", "taskSuffix", "sentry-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String readBundleIdFromFile$sentry_android_gradle_plugin(@NotNull File file) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Properties props = PropertiesUtil.Companion.load(file);
            String bundleId = props.getProperty("io.sentry.bundle-ids");
            boolean bl2 = bl = bundleId != null;
            if (!bl) {
                boolean bl3 = false;
                String string = "io.sentry.bundle-ids property is missing";
                throw new IllegalStateException(string.toString());
            }
            return bundleId;
        }

        @NotNull
        public final TaskProvider<BundleSourcesTask> register(@NotNull Project project, @NotNull SentryPluginExtension extension, @Nullable Provider<SentryTelemetryService> sentryTelemetryProvider, @NotNull SentryVariant variant, @NotNull TaskProvider<GenerateBundleIdTask> generateDebugIdTask, @NotNull TaskProvider<CollectSourcesTask> collectSourcesTask, @NotNull Provider<Directory> output, @NotNull Property<Boolean> debug, @NotNull Provider<String> cliExecutable, @NotNull Provider<String> sentryOrg, @NotNull Provider<String> sentryProject, @NotNull Property<String> sentryAuthToken, @NotNull Property<String> sentryUrl, @NotNull Property<Boolean> includeSourceContext, @NotNull String taskSuffix) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter(generateDebugIdTask, (String)"generateDebugIdTask");
            Intrinsics.checkNotNullParameter(collectSourcesTask, (String)"collectSourcesTask");
            Intrinsics.checkNotNullParameter(output, (String)"output");
            Intrinsics.checkNotNullParameter(debug, (String)"debug");
            Intrinsics.checkNotNullParameter(cliExecutable, (String)"cliExecutable");
            Intrinsics.checkNotNullParameter(sentryOrg, (String)"sentryOrg");
            Intrinsics.checkNotNullParameter(sentryProject, (String)"sentryProject");
            Intrinsics.checkNotNullParameter(sentryAuthToken, (String)"sentryAuthToken");
            Intrinsics.checkNotNullParameter(sentryUrl, (String)"sentryUrl");
            Intrinsics.checkNotNullParameter(includeSourceContext, (String)"includeSourceContext");
            Intrinsics.checkNotNullParameter((Object)taskSuffix, (String)"taskSuffix");
            TaskProvider taskProvider = project.getTasks().register("sentryBundleSources" + taskSuffix, BundleSourcesTask.class, new Action(debug, sentryOrg, sentryProject, sentryAuthToken, sentryUrl, collectSourcesTask, cliExecutable, project, variant, generateDebugIdTask, output, includeSourceContext, sentryTelemetryProvider, extension){
                final /* synthetic */ Property $debug;
                final /* synthetic */ Provider $sentryOrg;
                final /* synthetic */ Provider $sentryProject;
                final /* synthetic */ Property $sentryAuthToken;
                final /* synthetic */ Property $sentryUrl;
                final /* synthetic */ TaskProvider $collectSourcesTask;
                final /* synthetic */ Provider $cliExecutable;
                final /* synthetic */ Project $project;
                final /* synthetic */ SentryVariant $variant;
                final /* synthetic */ TaskProvider $generateDebugIdTask;
                final /* synthetic */ Provider $output;
                final /* synthetic */ Property $includeSourceContext;
                final /* synthetic */ Provider $sentryTelemetryProvider;
                final /* synthetic */ SentryPluginExtension $extension;

                public final void execute(BundleSourcesTask task) {
                    String it;
                    String string;
                    task.getDebug().set((Provider)this.$debug);
                    task.getSentryOrganization().set(this.$sentryOrg);
                    task.getSentryProject().set(this.$sentryProject);
                    task.getSentryAuthToken().set((Provider)this.$sentryAuthToken);
                    task.getSentryUrl().set((Provider)this.$sentryUrl);
                    task.getSourceDir().set(this.$collectSourcesTask.flatMap((Transformer)register.1.INSTANCE));
                    task.getCliExecutable().set(this.$cliExecutable);
                    String string2 = SentryPropertiesFileProvider.getPropertiesFilePath(this.$project, this.$variant);
                    if (string2 != null) {
                        it = string = string2;
                        boolean bl = false;
                        task.getSentryProperties().set(new File(it));
                    }
                    task.getBundleIdFile().set(this.$generateDebugIdTask.flatMap((Transformer)register.3.INSTANCE));
                    task.getOutput().set(this.$output);
                    task.getIncludeSourceContext().set((Provider)this.$includeSourceContext);
                    Provider provider = this.$sentryTelemetryProvider;
                    if (provider != null) {
                        it = string = provider;
                        boolean bl = false;
                        task.getSentryTelemetryService().set((Provider)it);
                    }
                    BundleSourcesTask bundleSourcesTask2 = task;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)bundleSourcesTask2), (String)"task");
                    SentryCliExecKt.asSentryCliExec(bundleSourcesTask2);
                    SentryTelemetryTaskWrapperKt.withSentryTelemetry((Task)task, this.$extension, (Provider<SentryTelemetryService>)this.$sentryTelemetryProvider);
                }
                {
                    this.$debug = property;
                    this.$sentryOrg = provider;
                    this.$sentryProject = provider2;
                    this.$sentryAuthToken = property2;
                    this.$sentryUrl = property3;
                    this.$collectSourcesTask = taskProvider;
                    this.$cliExecutable = provider3;
                    this.$project = project;
                    this.$variant = sentryVariant;
                    this.$generateDebugIdTask = taskProvider2;
                    this.$output = provider4;
                    this.$includeSourceContext = property4;
                    this.$sentryTelemetryProvider = provider5;
                    this.$extension = sentryPluginExtension;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.register(\n\u2026ryProvider)\n            }");
            return taskProvider;
        }

        public static /* synthetic */ TaskProvider register$default(Companion companion, Project project, SentryPluginExtension sentryPluginExtension, Provider provider, SentryVariant sentryVariant, TaskProvider taskProvider, TaskProvider taskProvider2, Provider provider2, Property property, Provider provider3, Provider provider4, Provider provider5, Property property2, Property property3, Property property4, String string, int n, Object object) {
            if ((n & 0x4000) != 0) {
                string = "";
            }
            return companion.register(project, sentryPluginExtension, (Provider<SentryTelemetryService>)provider, sentryVariant, (TaskProvider<GenerateBundleIdTask>)taskProvider, (TaskProvider<CollectSourcesTask>)taskProvider2, (Provider<Directory>)provider2, (Property<Boolean>)property, (Provider<String>)provider3, (Provider<String>)provider4, (Provider<String>)provider5, (Property<String>)property2, (Property<String>)property3, (Property<Boolean>)property4, string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

