/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.transforms;

import io.sentry.android.gradle.SentryPlugin;
import io.sentry.android.gradle.transforms.MetaInfStripTransform;
import io.sentry.android.gradle.util.SentryLoggingKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@CacheableTransform
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\fR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lio/sentry/android/gradle/transforms/MetaInfStripTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lio/sentry/android/gradle/transforms/MetaInfStripTransform$Parameters;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "isSignatureEntry", "", "Ljava/util/jar/JarEntry;", "(Ljava/util/jar/JarEntry;)Z", "javaVersion", "", "getJavaVersion", "(Ljava/util/jar/JarEntry;)I", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "jarOutputStream", "Ljava/util/jar/JarOutputStream;", "Ljava/io/File;", "Companion", "Parameters", "sentry-android-gradle-plugin"})
public abstract class MetaInfStripTransform
implements TransformAction<Parameters> {
    private static final Regex regex;
    private static final Regex signatureFileRegex;
    private static final String versionsDir = "META-INF/versions/";
    private static final int MIN_SUPPORTED_JAVA_VERSION = 11;
    @NotNull
    private static final Attribute<String> artifactType;
    @NotNull
    private static final Attribute<Boolean> metaInfStripped;
    @NotNull
    public static final Companion Companion;

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void transform(@NotNull TransformOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        Object object = this.getInputArtifact().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputArtifact.get()");
        File input = ((FileSystemLocation)object).getAsFile();
        JarFile jarFile = new JarFile(input);
        if (jarFile.isMultiRelease()) {
            File file = input;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"input");
            String outputFilename = FilesKt.getNameWithoutExtension((File)file) + "-meta-inf-stripped.jar";
            File tmpOutputFile = File.createTempFile("sentry-transformed-" + FilesKt.getNameWithoutExtension((File)input), ".jar");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            File file2 = tmpOutputFile;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tmpOutputFile");
            Closeable closeable = this.jarOutputStream(file2);
            Throwable throwable = null;
            try {
                int n;
                void isStillMultiRelease;
                JarOutputStream outStream = (JarOutputStream)closeable;
                boolean bl = false;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    InputStream inputStream;
                    JarEntry jarEntry;
                    JarEntry jarEntry2 = jarEntry = entries.nextElement();
                    Intrinsics.checkNotNullExpressionValue((Object)jarEntry2, (String)"jarEntry");
                    if (StringsKt.equals((String)jarEntry2.getName(), (String)"META-INF/MANIFEST.MF", (boolean)true)) continue;
                    if (this.isSignatureEntry(jarEntry)) {
                        Logger logger2 = SentryPlugin.Companion.getLogger$sentry_android_gradle_plugin();
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"SentryPlugin.logger");
                        SentryLoggingKt.warn$default(logger2, null, (Function0)new Function0<String>(this, jarFile, tmpOutputFile, outputs, (Ref.BooleanRef)isStillMultiRelease){
                            final /* synthetic */ MetaInfStripTransform this$0;
                            final /* synthetic */ JarFile $jarFile$inlined;
                            final /* synthetic */ File $tmpOutputFile$inlined;
                            final /* synthetic */ TransformOutputs $outputs$inlined;
                            final /* synthetic */ Ref.BooleanRef $isStillMultiRelease$inlined;
                            {
                                this.this$0 = metaInfStripTransform;
                                this.$jarFile$inlined = jarFile;
                                this.$tmpOutputFile$inlined = file;
                                this.$outputs$inlined = transformOutputs;
                                this.$isStillMultiRelease$inlined = booleanRef;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return StringsKt.trimIndent((String)("\n                            Signed Multirelease Jar (" + this.$jarFile$inlined.getName() + ") found, skipping transform.\n                            This might lead to auto-instrumentation issues due to a bug in AGP (https://issuetracker.google.com/issues/206655905).\n                            Please update to AGP >= 7.1.2 (https://developer.android.com/studio/releases/gradle-plugin) in order to keep using `autoInstrumentation` option.\n                            "));
                            }
                        }, 1, null);
                        tmpOutputFile.delete();
                        outputs.file(this.getInputArtifact());
                        return;
                    }
                    String string = jarEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarEntry.name");
                    if (StringsKt.startsWith((String)string, (String)versionsDir, (boolean)true)) {
                        int javaVersion = this.getJavaVersion(jarEntry);
                        if (javaVersion > 11) continue;
                        if (javaVersion > 0) {
                            isStillMultiRelease.element = true;
                        }
                    }
                    outStream.putNextEntry(jarEntry);
                    Intrinsics.checkNotNullExpressionValue((Object)jarFile.getInputStream(jarEntry), (String)"jarFile.getInputStream(jarEntry)");
                    n = 8192;
                    ByteStreamsKt.copyTo$default((InputStream)(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n)), (OutputStream)outStream, (int)0, (int)2, null);
                    outStream.closeEntry();
                }
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    manifest.getMainAttributes().put(Attributes.Name.MULTI_RELEASE, String.valueOf(isStillMultiRelease.element));
                    outStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                    OutputStream outputStream = outStream;
                    n = 8192;
                    manifest.write(outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n));
                    outStream.closeEntry();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            File transformedOutput = outputs.file((Object)outputFilename);
            Files.move(tmpOutputFile.toPath(), transformedOutput.toPath(), new CopyOption[0]);
        } else {
            outputs.file(this.getInputArtifact());
        }
    }

    private final boolean isSignatureEntry(JarEntry $this$isSignatureEntry) {
        String string = $this$isSignatureEntry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return signatureFileRegex.matches((CharSequence)string);
    }

    private final int getJavaVersion(JarEntry $this$javaVersion) {
        String string = $this$javaVersion.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        Object object = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        return object != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
    }

    private final JarOutputStream jarOutputStream(File $this$jarOutputStream) {
        File file = $this$jarOutputStream;
        return new JarOutputStream(new FileOutputStream(file));
    }

    static {
        Companion = new Companion(null);
        String string = "(?<=/)([0-9]*)(?=/)";
        regex = new Regex(string);
        string = "^META-INF/.*\\.(SF|DSA|RSA|EC)|^META-INF/SIG-.*";
        signatureFileRegex = new Regex(string);
        Attribute attribute = Attribute.of((String)"artifactType", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"Attribute.of(\"artifactType\", String::class.java)");
        artifactType = attribute;
        Attribute attribute2 = Attribute.of((String)"meta-inf-stripped", Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute2, (String)"Attribute.of(\"meta-inf-s\u2026an::class.javaObjectType)");
        metaInfStripped = attribute2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/sentry/android/gradle/transforms/MetaInfStripTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "invalidate", "Lorg/gradle/api/provider/Property;", "", "getInvalidate", "()Lorg/gradle/api/provider/Property;", "sentry-android-gradle-plugin"})
    public static interface Parameters
    extends TransformParameters {
        @Input
        @Optional
        @NotNull
        public Property<Long> getInvalidate();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/sentry/android/gradle/transforms/MetaInfStripTransform$Companion;", "", "()V", "MIN_SUPPORTED_JAVA_VERSION", "", "artifactType", "Lorg/gradle/api/attributes/Attribute;", "", "getArtifactType$sentry_android_gradle_plugin", "()Lorg/gradle/api/attributes/Attribute;", "metaInfStripped", "", "getMetaInfStripped$sentry_android_gradle_plugin", "regex", "Lkotlin/text/Regex;", "signatureFileRegex", "versionsDir", "register", "", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "forceInstrument", "register$sentry_android_gradle_plugin", "sentry-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final Attribute<String> getArtifactType$sentry_android_gradle_plugin() {
            return artifactType;
        }

        @NotNull
        public final Attribute<Boolean> getMetaInfStripped$sentry_android_gradle_plugin() {
            return metaInfStripped;
        }

        public final void register$sentry_android_gradle_plugin(@NotNull DependencyHandler dependencies, boolean forceInstrument) {
            Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
            dependencies.attributesSchema((Action)register.1.INSTANCE);
            dependencies.getArtifactTypes().named("jar", (Action)register.2.INSTANCE);
            dependencies.registerTransform(MetaInfStripTransform.class, new Action(forceInstrument){
                final /* synthetic */ boolean $forceInstrument;

                public final void execute(TransformSpec<Parameters> it) {
                    TransformSpec<Parameters> transformSpec = it;
                    Intrinsics.checkNotNullExpressionValue(transformSpec, (String)"it");
                    transformSpec.getFrom().attribute(MetaInfStripTransform.Companion.getArtifactType$sentry_android_gradle_plugin(), (Object)"jar").attribute(MetaInfStripTransform.Companion.getMetaInfStripped$sentry_android_gradle_plugin(), (Object)false);
                    it.getTo().attribute(MetaInfStripTransform.Companion.getArtifactType$sentry_android_gradle_plugin(), (Object)"processed-jar").attribute(MetaInfStripTransform.Companion.getMetaInfStripped$sentry_android_gradle_plugin(), (Object)true);
                    if (this.$forceInstrument) {
                        ((Parameters)it.getParameters()).getInvalidate().set((Object)System.currentTimeMillis());
                    }
                }
                {
                    this.$forceInstrument = bl;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

