/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.sourcecontext;

import io.sentry.android.gradle.extensions.SentryPluginExtension;
import io.sentry.android.gradle.sourcecontext.CollectSourcesTaskKt;
import io.sentry.android.gradle.sourcecontext.SourceCollector;
import io.sentry.android.gradle.tasks.DirectoryOutputTask;
import io.sentry.android.gradle.telemetry.SentryTelemetryService;
import io.sentry.android.gradle.telemetry.SentryTelemetryTaskWrapperKt;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lio/sentry/android/gradle/sourcecontext/CollectSourcesTask;", "Lio/sentry/android/gradle/tasks/DirectoryOutputTask;", "()V", "includeSourceContext", "Lorg/gradle/api/provider/Property;", "", "getIncludeSourceContext", "()Lorg/gradle/api/provider/Property;", "sourceDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSourceDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "action", "", "Companion", "sentry-android-gradle-plugin"})
public abstract class CollectSourcesTask
extends DirectoryOutputTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Input
    @NotNull
    public abstract Property<Boolean> getIncludeSourceContext();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getSourceDirs();

    @TaskAction
    public final void action() {
        File outDir = CollectSourcesTaskKt.getAndDelete(this.getOutput());
        outDir.mkdirs();
        new SourceCollector().collectSources(outDir, this.getSourceDirs());
    }

    public CollectSourcesTask() {
        this.setGroup("io.sentry");
        this.setDescription("Collects sources into a single directory so they can be bundled together.");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Object object = this.getIncludeSourceContext().getOrElse((Object)false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"includeSourceContext.getOrElse(false)");
                return (Boolean)object;
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jj\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0016\u0010\r\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lio/sentry/android/gradle/sourcecontext/CollectSourcesTask$Companion;", "", "()V", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/sentry/android/gradle/sourcecontext/CollectSourcesTask;", "project", "Lorg/gradle/api/Project;", "extension", "Lio/sentry/android/gradle/extensions/SentryPluginExtension;", "sentryTelemetryProvider", "Lorg/gradle/api/provider/Provider;", "Lio/sentry/android/gradle/telemetry/SentryTelemetryService;", "sourceDirs", "", "Lorg/gradle/api/file/Directory;", "output", "includeSourceContext", "Lorg/gradle/api/provider/Property;", "", "taskSuffix", "", "sentry-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final TaskProvider<CollectSourcesTask> register(@NotNull Project project, @NotNull SentryPluginExtension extension, @Nullable Provider<SentryTelemetryService> sentryTelemetryProvider, @Nullable Provider<? extends Collection<? extends Directory>> sourceDirs, @NotNull Provider<Directory> output, @NotNull Property<Boolean> includeSourceContext, @NotNull String taskSuffix) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter(output, (String)"output");
            Intrinsics.checkNotNullParameter(includeSourceContext, (String)"includeSourceContext");
            Intrinsics.checkNotNullParameter((Object)taskSuffix, (String)"taskSuffix");
            TaskProvider taskProvider = project.getTasks().register("sentryCollectSources" + taskSuffix, CollectSourcesTask.class, new Action(sourceDirs, output, includeSourceContext, extension, sentryTelemetryProvider){
                final /* synthetic */ Provider $sourceDirs;
                final /* synthetic */ Provider $output;
                final /* synthetic */ Property $includeSourceContext;
                final /* synthetic */ SentryPluginExtension $extension;
                final /* synthetic */ Provider $sentryTelemetryProvider;

                public final void execute(CollectSourcesTask task) {
                    task.getSourceDirs().setFrom(new Object[]{this.$sourceDirs});
                    task.getOutput().set(this.$output);
                    task.getIncludeSourceContext().set((Provider)this.$includeSourceContext);
                    CollectSourcesTask collectSourcesTask = task;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)collectSourcesTask), (String)"task");
                    SentryTelemetryTaskWrapperKt.withSentryTelemetry((Task)collectSourcesTask, this.$extension, (Provider<SentryTelemetryService>)this.$sentryTelemetryProvider);
                }
                {
                    this.$sourceDirs = provider;
                    this.$output = provider2;
                    this.$includeSourceContext = property;
                    this.$extension = sentryPluginExtension;
                    this.$sentryTelemetryProvider = provider3;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.register(\n\u2026elemetryProvider)\n      }");
            return taskProvider;
        }

        public static /* synthetic */ TaskProvider register$default(Companion companion, Project project, SentryPluginExtension sentryPluginExtension, Provider provider, Provider provider2, Provider provider3, Property property, String string, int n, Object object) {
            if ((n & 0x40) != 0) {
                string = "";
            }
            return companion.register(project, sentryPluginExtension, (Provider<SentryTelemetryService>)provider, (Provider<? extends Collection<? extends Directory>>)provider2, (Provider<Directory>)provider3, (Property<Boolean>)property, string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

