/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.tasks;

import io.sentry.android.gradle.ManifestWriter;
import io.sentry.android.gradle.extensions.SentryPluginExtension;
import io.sentry.android.gradle.services.SentryModulesService;
import io.sentry.android.gradle.tasks.SentryGenerateIntegrationListTask;
import io.sentry.android.gradle.telemetry.SentryTelemetryService;
import io.sentry.android.gradle.telemetry.SentryTelemetryTaskWrapperKt;
import io.sentry.android.gradle.util.SentryLoggingKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lio/sentry/android/gradle/tasks/SentryGenerateIntegrationListTask;", "Lorg/gradle/api/DefaultTask;", "()V", "integrations", "Lorg/gradle/api/provider/SetProperty;", "", "getIntegrations", "()Lorg/gradle/api/provider/SetProperty;", "mergedManifest", "Lorg/gradle/api/file/RegularFileProperty;", "getMergedManifest", "()Lorg/gradle/api/file/RegularFileProperty;", "updatedManifest", "getUpdatedManifest", "writeIntegrationListToManifest", "", "Companion", "sentry-android-gradle-plugin"})
public abstract class SentryGenerateIntegrationListTask
extends DefaultTask {
    @NotNull
    public static final String ATTR_INTEGRATIONS = "io.sentry.gradle-plugin-integrations";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getMergedManifest();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getUpdatedManifest();

    @Input
    @NotNull
    public abstract SetProperty<String> getIntegrations();

    @TaskAction
    public final void writeIntegrationListToManifest() {
        org.gradle.api.logging.Logger logger2 = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        SentryLoggingKt.info$default((Logger)logger2, null, (Function0)new Function0<String>(this){
            final /* synthetic */ SentryGenerateIntegrationListTask this$0;

            @NotNull
            public final String invoke() {
                return "SentryGenerateIntegrationListTask - outputFile: " + (RegularFile)this.this$0.getUpdatedManifest().get();
            }
            {
                this.this$0 = sentryGenerateIntegrationListTask;
                super(0);
            }
        }, 1, null);
        Set integrations = (Set)this.getIntegrations().get();
        File manifestFile = (File)this.getMergedManifest().getAsFile().get();
        File updatedManifestFile = (File)this.getUpdatedManifest().getAsFile().get();
        Set set = integrations;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"integrations");
        Collection collection = set;
        if (!collection.isEmpty()) {
            ManifestWriter manifestWriter = new ManifestWriter();
            String integrationsList = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)integrations)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            File file = manifestFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"manifestFile");
            File file2 = updatedManifestFile;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"updatedManifestFile");
            manifestWriter.writeMetaData(file, file2, ATTR_INTEGRATIONS, integrationsList);
        } else {
            org.gradle.api.logging.Logger logger3 = this.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"logger");
            SentryLoggingKt.info$default((Logger)logger3, null, writeIntegrationListToManifest.2.INSTANCE, 1, null);
            Files.copy(manifestFile.toPath(), updatedManifestFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public SentryGenerateIntegrationListTask() {
        this.setDescription("Writes enabled integrations to AndroidManifest.xml");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/sentry/android/gradle/tasks/SentryGenerateIntegrationListTask$Companion;", "", "()V", "ATTR_INTEGRATIONS", "", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/sentry/android/gradle/tasks/SentryGenerateIntegrationListTask;", "project", "Lorg/gradle/api/Project;", "extension", "Lio/sentry/android/gradle/extensions/SentryPluginExtension;", "sentryTelemetryProvider", "Lorg/gradle/api/provider/Provider;", "Lio/sentry/android/gradle/telemetry/SentryTelemetryService;", "sentryModulesService", "Lio/sentry/android/gradle/services/SentryModulesService;", "variantName", "sentry-android-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final TaskProvider<SentryGenerateIntegrationListTask> register(@NotNull Project project, @NotNull SentryPluginExtension extension, @Nullable Provider<SentryTelemetryService> sentryTelemetryProvider, @NotNull Provider<SentryModulesService> sentryModulesService, @NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter(sentryModulesService, (String)"sentryModulesService");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            TaskProvider taskProvider = project.getTasks().register(variantName + "SentryGenerateIntegrationListTask", SentryGenerateIntegrationListTask.class, new Action(sentryModulesService, project, extension, sentryTelemetryProvider){
                final /* synthetic */ Provider $sentryModulesService;
                final /* synthetic */ Project $project;
                final /* synthetic */ SentryPluginExtension $extension;
                final /* synthetic */ Provider $sentryTelemetryProvider;

                public final void execute(SentryGenerateIntegrationListTask it) {
                    it.getIntegrations().set(this.$sentryModulesService.flatMap(new Transformer(this){
                        final /* synthetic */ register.1 this$0;

                        public final Provider<? extends Set<String>> transform(SentryModulesService service) {
                            return service.retrieveEnabledInstrumentationFeatures(this.this$0.$project);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                    it.usesService(this.$sentryModulesService);
                    SentryGenerateIntegrationListTask sentryGenerateIntegrationListTask = it;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)sentryGenerateIntegrationListTask), (String)"it");
                    SentryTelemetryTaskWrapperKt.withSentryTelemetry((Task)sentryGenerateIntegrationListTask, this.$extension, (Provider<SentryTelemetryService>)this.$sentryTelemetryProvider);
                }
                {
                    this.$sentryModulesService = provider;
                    this.$project = project;
                    this.$extension = sentryPluginExtension;
                    this.$sentryTelemetryProvider = provider2;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.register(\n\u2026elemetryProvider)\n      }");
            return taskProvider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

