/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.sourcecontext;

import io.sentry.android.gradle.SentryPlugin;
import io.sentry.android.gradle.util.SentryLoggingKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/sentry/android/gradle/sourcecontext/SourceCollector;", "", "()V", "collectSources", "", "outDir", "Ljava/io/File;", "sourceDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "sentry-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCollectSourcesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectSourcesTask.kt\nio/sentry/android/gradle/sourcecontext/SourceCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,125:1\n1855#2:126\n1856#2:129\n1295#3,2:127\n*E\n*S KotlinDebug\n*F\n+ 1 CollectSourcesTask.kt\nio/sentry/android/gradle/sourcecontext/SourceCollector\n*L\n75#1:126\n75#1:129\n78#1,2:127\n*E\n"})
public final class SourceCollector {
    public final void collectSources(@NotNull File outDir, @NotNull ConfigurableFileCollection sourceDirs) {
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter((Object)sourceDirs, (String)"sourceDirs");
        Iterable $this$forEach$iv = (Iterable)sourceDirs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File sourceDir = (File)element$iv;
            boolean bl = false;
            if (sourceDir.exists()) {
                Logger logger2 = SentryPlugin.Companion.getLogger$sentry_android_gradle_plugin();
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"SentryPlugin.logger");
                SentryLoggingKt.debug$default(logger2, null, (Function0)new Function0<String>(sourceDir){
                    final /* synthetic */ File $sourceDir;

                    @NotNull
                    public final String invoke() {
                        File file = this.$sourceDir;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"sourceDir");
                        return "Collecting sources in " + file.getAbsolutePath();
                    }
                    {
                        this.$sourceDir = file;
                        super(0);
                    }
                }, 1, null);
                File file = sourceDir;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"sourceDir");
                Sequence $this$forEach$iv2 = (Sequence)FilesKt.walk$default((File)file, null, (int)1, null);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File sourceFile = (File)element$iv2;
                    boolean bl2 = false;
                    String string = sourceFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceFile.absolutePath");
                    String string2 = sourceDir.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceDir.absolutePath");
                    String string3 = StringsKt.removePrefix((String)string, (CharSequence)string2);
                    String string4 = File.separator;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"File.separator");
                    String relativePath = StringsKt.removePrefix((String)string3, (CharSequence)string4);
                    File targetFile = FilesKt.resolve((File)outDir, (File)new File(relativePath));
                    if (!sourceFile.isFile()) continue;
                    if (StringsKt.isBlank((CharSequence)relativePath)) {
                        Logger logger3 = SentryPlugin.Companion.getLogger$sentry_android_gradle_plugin();
                        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"SentryPlugin.logger");
                        SentryLoggingKt.debug$default(logger3, null, (Function0)new Function0<String>(sourceFile){
                            final /* synthetic */ File $sourceFile;

                            @NotNull
                            public final String invoke() {
                                return "Skipping " + this.$sourceFile.getAbsolutePath() + " as the plugin was unable to determine a relative path for it.";
                            }
                            {
                                this.$sourceFile = file;
                                super(0);
                            }
                        }, 1, null);
                        continue;
                    }
                    Logger logger4 = SentryPlugin.Companion.getLogger$sentry_android_gradle_plugin();
                    Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"SentryPlugin.logger");
                    SentryLoggingKt.debug$default(logger4, null, (Function0)new Function0<String>(sourceFile, targetFile){
                        final /* synthetic */ File $sourceFile;
                        final /* synthetic */ File $targetFile;

                        @NotNull
                        public final String invoke() {
                            return "Copying file " + this.$sourceFile.getAbsolutePath() + " to " + this.$targetFile.getAbsolutePath();
                        }
                        {
                            this.$sourceFile = file;
                            this.$targetFile = file2;
                            super(0);
                        }
                    }, 1, null);
                    FilesKt.copyTo$default((File)sourceFile, (File)targetFile, (boolean)true, (int)0, (int)4, null);
                }
                continue;
            }
            Logger logger5 = SentryPlugin.Companion.getLogger$sentry_android_gradle_plugin();
            Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"SentryPlugin.logger");
            SentryLoggingKt.debug$default(logger5, null, (Function0)new Function0<String>(sourceDir){
                final /* synthetic */ File $sourceDir;

                @NotNull
                public final String invoke() {
                    File file = this.$sourceDir;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"sourceDir");
                    return "Skipping source collection in " + file.getAbsolutePath() + " as it doesn't exist.";
                }
                {
                    this.$sourceDir = file;
                    super(0);
                }
            }, 1, null);
        }
    }
}

