/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.gradle.autoinstall.override;

import io.sentry.android.gradle.SentryPlugin;
import io.sentry.android.gradle.autoinstall.AutoInstallState;
import io.sentry.android.gradle.autoinstall.InstallStrategyRegistrar;
import io.sentry.android.gradle.autoinstall.override.WarnOnOverrideStrategy;
import io.sentry.android.gradle.util.SemVer;
import io.sentry.android.gradle.util.SentryLoggingKt;
import io.sentry.android.gradle.util.SentryModules;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/sentry/android/gradle/autoinstall/override/WarnOnOverrideStrategy;", "Lorg/gradle/api/artifacts/ComponentMetadataRule;", "logger", "Lorg/slf4j/Logger;", "(Lorg/slf4j/Logger;)V", "()V", "execute", "", "context", "Lorg/gradle/api/artifacts/ComponentMetadataContext;", "parseVersionSafely", "Lio/sentry/android/gradle/util/SemVer;", "version", "", "Registrar", "sentry-android-gradle-plugin"})
public abstract class WarnOnOverrideStrategy
implements ComponentMetadataRule {
    private Logger logger;
    private static final Set<ModuleIdentifier> sentryModules;
    @NotNull
    public static final Registrar Registrar;

    public void execute(@NotNull ComponentMetadataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AutoInstallState autoInstallState = AutoInstallState.Companion.getInstance$default(AutoInstallState.Companion, null, 1, null);
        if (!autoInstallState.getEnabled()) {
            return;
        }
        SemVer semVer = this.parseVersionSafely(autoInstallState.getSentryVersion());
        if (semVer == null) {
            return;
        }
        SemVer providedVersion = semVer;
        ComponentMetadataDetails componentMetadataDetails = context.getDetails();
        Intrinsics.checkNotNullExpressionValue((Object)componentMetadataDetails, (String)"context.details");
        ModuleVersionIdentifier moduleVersionIdentifier = componentMetadataDetails.getId();
        Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"context.details.id");
        String string = moduleVersionIdentifier.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.details.id.version");
        SemVer semVer2 = this.parseVersionSafely(string);
        if (semVer2 == null) {
            return;
        }
        SemVer userVersion = semVer2;
        if (userVersion.compareTo(providedVersion) < 0) {
            ComponentMetadataDetails componentMetadataDetails2 = context.getDetails();
            Intrinsics.checkNotNullExpressionValue((Object)componentMetadataDetails2, (String)"context.details");
            ModuleVersionIdentifier moduleVersionIdentifier2 = componentMetadataDetails2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier2, (String)"context.details.id");
            this.logger.warn("WARNING: Version of '" + moduleVersionIdentifier2.getModule() + "' was overridden from '" + userVersion + "' to '" + providedVersion + "' by the Sentry Gradle plugin. If you want to use the older version, you can add `autoInstallation.sentryVersion.set(\"" + userVersion + "\")` in the `sentry {}` plugin configuration block");
        }
    }

    private final SemVer parseVersionSafely(String version) {
        SemVer semVer;
        try {
            semVer = SemVer.Companion.parse(version);
        }
        catch (Throwable t) {
            SentryLoggingKt.info$default(this.logger, null, (Function0)new Function0<String>(version){
                final /* synthetic */ String $version;

                @NotNull
                public final String invoke() {
                    return "Unable to parse version " + this.$version + " as a semantic version.";
                }
                {
                    this.$version = string;
                    super(0);
                }
            }, 1, null);
            semVer = null;
        }
        return semVer;
    }

    public WarnOnOverrideStrategy(@NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
    }

    @Inject
    public WarnOnOverrideStrategy() {
        Logger logger2 = SentryPlugin.Companion.getLogger$sentry_android_gradle_plugin();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"SentryPlugin.logger");
        this(logger2);
    }

    static {
        Registrar = new Registrar(null);
        sentryModules = SetsKt.setOf((Object[])new ModuleIdentifier[]{SentryModules.INSTANCE.getSENTRY$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID_CORE$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID_NDK$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID_OKHTTP$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID_SQLITE$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID_COMPOSE$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID_FRAGMENT$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID_NAVIGATION$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_ANDROID_TIMBER$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_OKHTTP$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_KOTLIN_EXTENSIONS$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_GRAPHQL$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_JDBC$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_LOG4J2$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_LOGBACK$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_QUARTZ$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_SPRING5$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_SPRING6$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_SPRING_BOOT2$sentry_android_gradle_plugin(), SentryModules.INSTANCE.getSENTRY_SPRING_BOOT3$sentry_android_gradle_plugin()});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/sentry/android/gradle/autoinstall/override/WarnOnOverrideStrategy$Registrar;", "Lio/sentry/android/gradle/autoinstall/InstallStrategyRegistrar;", "()V", "sentryModules", "", "Lorg/gradle/api/artifacts/ModuleIdentifier;", "kotlin.jvm.PlatformType", "register", "", "component", "Lorg/gradle/api/artifacts/dsl/ComponentMetadataHandler;", "sentry-android-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nWarnOnOverrideStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WarnOnOverrideStrategy.kt\nio/sentry/android/gradle/autoinstall/override/WarnOnOverrideStrategy$Registrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1863#2,2:91\n*E\n*S KotlinDebug\n*F\n+ 1 WarnOnOverrideStrategy.kt\nio/sentry/android/gradle/autoinstall/override/WarnOnOverrideStrategy$Registrar\n*L\n84#1,2:91\n*E\n"})
    public static final class Registrar
    implements InstallStrategyRegistrar {
        @Override
        public void register(@NotNull ComponentMetadataHandler component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Iterable $this$forEach$iv = sentryModules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleIdentifier module = (ModuleIdentifier)element$iv;
                boolean bl = false;
                component.withModule((Object)module.toString(), WarnOnOverrideStrategy.class, (Action)register.1.1.INSTANCE);
            }
        }

        private Registrar() {
        }

        public /* synthetic */ Registrar(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

