/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.navigation;

import android.content.res.Resources;
import android.os.Bundle;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.Scope;
import io.sentry.ScopeCallback;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.android.navigation.SentryNavigationListener;
import io.sentry.protocol.TransactionNameSource;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015H\u0002J\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016J.\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00102\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\u001c\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0015*\u0004\u0018\u00010\rH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/sentry/android/navigation/SentryNavigationListener;", "Landroidx/navigation/NavController$OnDestinationChangedListener;", "hub", "Lio/sentry/IHub;", "enableNavigationBreadcrumbs", "", "enableNavigationTracing", "(Lio/sentry/IHub;ZZ)V", "activeTransaction", "Lio/sentry/ITransaction;", "isPerformanceEnabled", "()Z", "previousArgs", "Landroid/os/Bundle;", "previousDestinationRef", "Ljava/lang/ref/WeakReference;", "Landroidx/navigation/NavDestination;", "addBreadcrumb", "", "destination", "arguments", "", "", "", "onDestinationChanged", "controller", "Landroidx/navigation/NavController;", "startTracing", "stopTracing", "refined", "Companion", "sentry-android-navigation_release"})
public final class SentryNavigationListener
implements NavController.OnDestinationChangedListener {
    private WeakReference<NavDestination> previousDestinationRef;
    private Bundle previousArgs;
    private ITransaction activeTransaction;
    private final IHub hub;
    private final boolean enableNavigationBreadcrumbs;
    private final boolean enableNavigationTracing;
    @NotNull
    public static final String NAVIGATION_OP = "navigation";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final boolean isPerformanceEnabled() {
        SentryOptions sentryOptions = this.hub.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)sentryOptions, (String)"hub.options");
        return sentryOptions.isTracingEnabled() && this.enableNavigationTracing;
    }

    public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Map<String, Object> toArguments = this.refined(arguments);
        this.addBreadcrumb(destination, toArguments);
        this.startTracing(controller, destination, toArguments);
        this.previousDestinationRef = new WeakReference<NavDestination>(destination);
        this.previousArgs = arguments;
    }

    private final void addBreadcrumb(NavDestination destination, Map<String, ? extends Object> arguments) {
        String to;
        Object it;
        String from;
        Breadcrumb breadcrumb;
        if (!this.enableNavigationBreadcrumbs) {
            return;
        }
        Breadcrumb $this$apply = breadcrumb = new Breadcrumb();
        boolean bl = false;
        $this$apply.setType(NAVIGATION_OP);
        $this$apply.setCategory(NAVIGATION_OP);
        NavDestination navDestination = this.previousDestinationRef;
        String string = from = navDestination != null && (navDestination = (NavDestination)navDestination.get()) != null ? navDestination.getRoute() : null;
        if (string != null) {
            String string2 = string;
            it = string2;
            boolean bl2 = false;
            Map map = $this$apply.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
            map.put("from", '/' + (String)it);
        }
        Map<String, Object> fromArguments = this.refined(this.previousArgs);
        it = fromArguments;
        if (!it.isEmpty()) {
            Map map = $this$apply.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
            map.put("from_arguments", fromArguments);
        }
        String string3 = to = destination.getRoute();
        if (string3 != null) {
            String string4;
            String it2 = string4 = string3;
            boolean bl3 = false;
            Map map = $this$apply.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"data");
            map.put("to", '/' + it2);
        }
        Map<String, ? extends Object> map = arguments;
        if (!map.isEmpty()) {
            Map map2 = $this$apply.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"data");
            map2.put("to_arguments", arguments);
        }
        $this$apply.setLevel(SentryLevel.INFO);
        Breadcrumb breadcrumb2 = breadcrumb;
        Hint hint = new Hint();
        hint.set("android:navigationDestination", (Object)destination);
        this.hub.addBreadcrumb(breadcrumb2, hint);
    }

    private final void startTracing(NavController controller, NavDestination destination, Map<String, ? extends Object> arguments) {
        TransactionOptions e2;
        if (!this.isPerformanceEnabled()) {
            return;
        }
        if (this.activeTransaction != null) {
            this.stopTracing();
        }
        if (Intrinsics.areEqual((Object)destination.getNavigatorName(), (Object)"activity")) {
            SentryOptions sentryOptions = this.hub.getOptions();
            Intrinsics.checkNotNullExpressionValue((Object)sentryOptions, (String)"hub.options");
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Navigating to activity destination, no transaction captured.", new Object[0]);
            return;
        }
        String string = destination.getRoute();
        if (string == null) {
            String string2;
            try {
                string2 = controller.getContext().getResources().getResourceEntryName(destination.getId());
            }
            catch (Resources.NotFoundException e2) {
                SentryOptions sentryOptions = this.hub.getOptions();
                Intrinsics.checkNotNullExpressionValue((Object)sentryOptions, (String)"hub.options");
                sentryOptions.getLogger().log(SentryLevel.DEBUG, "Destination id cannot be retrieved from Resources, no transaction captured.", new Object[0]);
                return;
            }
            string = string2;
        }
        String name = string;
        StringBuilder stringBuilder = new StringBuilder().append("/");
        String string3 = name;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
        name = stringBuilder.append(StringsKt.substringBefore$default((String)string3, (char)'/', null, (int)2, null)).toString();
        TransactionOptions it = e2 = new TransactionOptions();
        boolean bl = false;
        it.setWaitForChildren(true);
        SentryOptions sentryOptions = this.hub.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)sentryOptions, (String)"hub.options");
        it.setIdleTimeout(sentryOptions.getIdleTimeout());
        it.setTrimEnd(true);
        TransactionOptions transactonOptions = e2;
        ITransaction iTransaction = this.hub.startTransaction(new TransactionContext(name, TransactionNameSource.ROUTE, NAVIGATION_OP), transactonOptions);
        Intrinsics.checkNotNullExpressionValue((Object)iTransaction, (String)"hub.startTransaction(\n  \u2026ansactonOptions\n        )");
        ITransaction transaction = iTransaction;
        Map<String, ? extends Object> map = arguments;
        if (!map.isEmpty()) {
            transaction.setData("arguments", arguments);
        }
        this.hub.configureScope(new ScopeCallback(transaction){
            final /* synthetic */ ITransaction $transaction;

            public final void run(@NotNull Scope scope) {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                scope.withTransaction(new Scope.IWithTransaction(this, scope){
                    final /* synthetic */ startTracing.1 this$0;
                    final /* synthetic */ Scope $scope;

                    public final void accept(@Nullable ITransaction tx) {
                        if (tx == null) {
                            Scope scope = this.$scope;
                            Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"scope");
                            scope.setTransaction(this.this$0.$transaction);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$scope = scope;
                    }
                });
            }
            {
                this.$transaction = iTransaction;
            }
        });
        this.activeTransaction = transaction;
    }

    private final void stopTracing() {
        ITransaction iTransaction = this.activeTransaction;
        if (iTransaction == null || (iTransaction = iTransaction.getStatus()) == null) {
            iTransaction = SpanStatus.OK;
        }
        Intrinsics.checkNotNullExpressionValue((Object)iTransaction, (String)"activeTransaction?.status ?: SpanStatus.OK");
        ITransaction status = iTransaction;
        ITransaction iTransaction2 = this.activeTransaction;
        if (iTransaction2 != null) {
            iTransaction2.finish((SpanStatus)status);
        }
        this.hub.configureScope(new ScopeCallback(this){
            final /* synthetic */ SentryNavigationListener this$0;

            public final void run(@NotNull Scope scope) {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                scope.withTransaction(new Scope.IWithTransaction(this, scope){
                    final /* synthetic */ stopTracing.1 this$0;
                    final /* synthetic */ Scope $scope;

                    public final void accept(@Nullable ITransaction tx) {
                        if (Intrinsics.areEqual((Object)tx, (Object)SentryNavigationListener.access$getActiveTransaction$p(this.this$0.this$0))) {
                            this.$scope.clearTransaction();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$scope = scope;
                    }
                });
            }
            {
                this.this$0 = sentryNavigationListener;
            }
        });
        this.activeTransaction = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> refined(Bundle $this$refined) {
        Map map;
        Bundle bundle = $this$refined;
        if (bundle != null) {
            void $this$associateWith$iv;
            String it;
            void $this$filterTo$iv$iv;
            Bundle bundle2;
            Bundle args = bundle2 = bundle;
            boolean bl = false;
            Set set = args.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"args.keySet()");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)"android-support-nav:controller:deepLinkIntent") ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                it = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl3 = false;
                Object object = args.get(it);
                map2.put(t, object);
            }
            map = result$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @JvmOverloads
    public SentryNavigationListener(@NotNull IHub hub, boolean enableNavigationBreadcrumbs, boolean enableNavigationTracing) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this.hub = hub;
        this.enableNavigationBreadcrumbs = enableNavigationBreadcrumbs;
        this.enableNavigationTracing = enableNavigationTracing;
    }

    public /* synthetic */ SentryNavigationListener(IHub iHub, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"HubAdapter.getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(iHub, bl, bl2);
    }

    @JvmOverloads
    public SentryNavigationListener(@NotNull IHub hub, boolean enableNavigationBreadcrumbs) {
        this(hub, enableNavigationBreadcrumbs, false, 4, null);
    }

    @JvmOverloads
    public SentryNavigationListener(@NotNull IHub hub) {
        this(hub, false, false, 6, null);
    }

    @JvmOverloads
    public SentryNavigationListener() {
        this(null, false, false, 7, null);
    }

    public static final /* synthetic */ ITransaction access$getActiveTransaction$p(SentryNavigationListener $this) {
        return $this.activeTransaction;
    }

    public static final /* synthetic */ void access$setActiveTransaction$p(SentryNavigationListener $this, ITransaction iTransaction) {
        $this.activeTransaction = iTransaction;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/navigation/SentryNavigationListener$Companion;", "", "()V", "NAVIGATION_OP", "", "sentry-android-navigation_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

