/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.TargetApi;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.OnRootViewsChangedListener;
import io.sentry.android.replay.Recorder;
import io.sentry.android.replay.RootViewsSpy;
import io.sentry.android.replay.ScreenshotRecorder;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.TouchRecorderCallback;
import io.sentry.android.replay.WindowRecorder;
import io.sentry.android.replay.WindowsKt;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.FixedWindowCallback;
import io.sentry.android.replay.util.MainLooperHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 .2\u00020\u0001:\u0003./0B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020%H\u0016J\f\u0010,\u001a\u00020%*\u00020\u001dH\u0002J\f\u0010-\u001a\u00020%*\u00020\u001dH\u0002R#\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0011\u001a\u0004\b!\u0010\"R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/sentry/android/replay/WindowRecorder;", "Lio/sentry/android/replay/Recorder;", "options", "Lio/sentry/SentryOptions;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "touchRecorderCallback", "Lio/sentry/android/replay/TouchRecorderCallback;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderCallback;Lio/sentry/android/replay/TouchRecorderCallback;Lio/sentry/android/replay/util/MainLooperHandler;)V", "capturer", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getCapturer", "()Ljava/util/concurrent/ScheduledExecutorService;", "capturer$delegate", "Lkotlin/Lazy;", "capturingTask", "Ljava/util/concurrent/ScheduledFuture;", "isRecording", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onRootViewsChangedListener", "Lio/sentry/android/replay/OnRootViewsChangedListener;", "recorder", "Lio/sentry/android/replay/ScreenshotRecorder;", "rootViews", "Ljava/util/ArrayList;", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "rootViewsSpy", "Lio/sentry/android/replay/RootViewsSpy;", "getRootViewsSpy", "()Lio/sentry/android/replay/RootViewsSpy;", "rootViewsSpy$delegate", "close", "", "pause", "resume", "start", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "stop", "startGestureTracking", "stopGestureTracking", "Companion", "RecorderExecutorServiceThreadFactory", "SentryReplayGestureRecorder", "sentry-android-replay_release"})
@TargetApi(value=26)
@SourceDebugExtension(value={"SMAP\nWindowRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1855#2,2:169\n*S KotlinDebug\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n*L\n92#1:169,2\n*E\n"})
public final class WindowRecorder
implements Recorder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @Nullable
    private final TouchRecorderCallback touchRecorderCallback;
    @NotNull
    private final MainLooperHandler mainLooperHandler;
    @NotNull
    private final Lazy rootViewsSpy$delegate;
    @NotNull
    private final AtomicBoolean isRecording;
    @NotNull
    private final ArrayList<WeakReference<View>> rootViews;
    @Nullable
    private ScreenshotRecorder recorder;
    @Nullable
    private ScheduledFuture<?> capturingTask;
    @NotNull
    private final Lazy capturer$delegate;
    @NotNull
    private final OnRootViewsChangedListener onRootViewsChangedListener;
    @NotNull
    private static final String TAG = "WindowRecorder";

    public WindowRecorder(@NotNull SentryOptions options, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback, @Nullable TouchRecorderCallback touchRecorderCallback, @NotNull MainLooperHandler mainLooperHandler) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)mainLooperHandler, (String)"mainLooperHandler");
        this.options = options;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.touchRecorderCallback = touchRecorderCallback;
        this.mainLooperHandler = mainLooperHandler;
        this.rootViewsSpy$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)rootViewsSpy.2.INSTANCE);
        this.isRecording = new AtomicBoolean(false);
        this.rootViews = new ArrayList();
        this.capturer$delegate = LazyKt.lazy((Function0)capturer.2.INSTANCE);
        this.onRootViewsChangedListener = (arg_0, arg_1) -> WindowRecorder.onRootViewsChangedListener$lambda$0(this, arg_0, arg_1);
    }

    public /* synthetic */ WindowRecorder(SentryOptions sentryOptions, ScreenshotRecorderCallback screenshotRecorderCallback, TouchRecorderCallback touchRecorderCallback, MainLooperHandler mainLooperHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            screenshotRecorderCallback = null;
        }
        if ((n & 4) != 0) {
            touchRecorderCallback = null;
        }
        this(sentryOptions, screenshotRecorderCallback, touchRecorderCallback, mainLooperHandler);
    }

    private final RootViewsSpy getRootViewsSpy() {
        Lazy lazy = this.rootViewsSpy$delegate;
        return (RootViewsSpy)lazy.getValue();
    }

    private final ScheduledExecutorService getCapturer() {
        Lazy lazy = this.capturer$delegate;
        return (ScheduledExecutorService)lazy.getValue();
    }

    @Override
    public void start(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        if (this.isRecording.getAndSet(true)) {
            return;
        }
        this.recorder = new ScreenshotRecorder(recorderConfig, this.options, this.mainLooperHandler, this.screenshotRecorderCallback);
        ((Collection)this.getRootViewsSpy().getListeners()).add(this.onRootViewsChangedListener);
        ScheduledExecutorService scheduledExecutorService = this.getCapturer();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"capturer");
        this.capturingTask = ExecutorsKt.scheduleAtFixedRateSafely(scheduledExecutorService, this.options, "WindowRecorder.capture", 0L, 1000L / (long)recorderConfig.getFrameRate(), TimeUnit.MILLISECONDS, () -> WindowRecorder.start$lambda$1(this));
    }

    @Override
    public void resume() {
        block0: {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.resume();
        }
    }

    @Override
    public void pause() {
        block0: {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.pause();
        }
    }

    @Override
    public void stop() {
        ((Collection)this.getRootViewsSpy().getListeners()).remove(this.onRootViewsChangedListener);
        Iterable $this$forEach$iv = this.rootViews;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WeakReference it = (WeakReference)element$iv;
            boolean bl = false;
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder == null) continue;
            screenshotRecorder.unbind((View)it.get());
        }
        ScreenshotRecorder screenshotRecorder = this.recorder;
        if (screenshotRecorder != null) {
            screenshotRecorder.close();
        }
        this.rootViews.clear();
        this.recorder = null;
        ScheduledFuture<?> scheduledFuture = this.capturingTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.capturingTask = null;
        this.isRecording.set(false);
    }

    @Override
    public void close() {
        this.stop();
        ScheduledExecutorService scheduledExecutorService = this.getCapturer();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"capturer");
        ExecutorsKt.gracefullyShutdown(scheduledExecutorService, this.options);
    }

    private final void startGestureTracking(View $this$startGestureTracking) {
        Window window = WindowsKt.getPhoneWindow($this$startGestureTracking);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is invalid, not tracking gestures", new Object[0]);
            return;
        }
        if (this.touchRecorderCallback == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "TouchRecorderCallback is null, not tracking gestures", new Object[0]);
            return;
        }
        Window.Callback delegate = window.getCallback();
        window.setCallback((Window.Callback)new SentryReplayGestureRecorder(this.options, this.touchRecorderCallback, delegate));
    }

    private final void stopGestureTracking(View $this$stopGestureTracking) {
        Window window = WindowsKt.getPhoneWindow($this$stopGestureTracking);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window was null in stopGestureTracking", new Object[0]);
            return;
        }
        if (window.getCallback() instanceof SentryReplayGestureRecorder) {
            Window.Callback callback = window.getCallback();
            Intrinsics.checkNotNull((Object)callback, (String)"null cannot be cast to non-null type io.sentry.android.replay.WindowRecorder.SentryReplayGestureRecorder");
            Window.Callback delegate = ((SentryReplayGestureRecorder)callback).delegate;
            window.setCallback(delegate);
        }
    }

    private static final void onRootViewsChangedListener$lambda$0(WindowRecorder this$0, View root, boolean added) {
        block4: {
            View newRoot;
            block3: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                if (!added) break block3;
                this$0.rootViews.add(new WeakReference<View>(root));
                ScreenshotRecorder screenshotRecorder = this$0.recorder;
                if (screenshotRecorder != null) {
                    screenshotRecorder.bind(root);
                }
                this$0.startGestureTracking(root);
                break block4;
            }
            this$0.stopGestureTracking(root);
            ScreenshotRecorder screenshotRecorder = this$0.recorder;
            if (screenshotRecorder != null) {
                screenshotRecorder.unbind(root);
            }
            CollectionsKt.removeAll((List)this$0.rootViews, (Function1)((Function1)new Function1<WeakReference<View>, Boolean>(root){
                final /* synthetic */ View $root;
                {
                    this.$root = $root;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull WeakReference<View> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return Intrinsics.areEqual(it.get(), (Object)this.$root);
                }
            }));
            WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)this$0.rootViews);
            Object object = newRoot = weakReference != null ? (View)weakReference.get() : null;
            if (newRoot == null || Intrinsics.areEqual((Object)root, (Object)newRoot)) break block4;
            ScreenshotRecorder screenshotRecorder2 = this$0.recorder;
            if (screenshotRecorder2 != null) {
                screenshotRecorder2.bind(newRoot);
            }
        }
    }

    private static final void start$lambda$1(WindowRecorder this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ScreenshotRecorder screenshotRecorder = this$0.recorder;
            if (screenshotRecorder == null) break block0;
            screenshotRecorder.capture();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/sentry/android/replay/WindowRecorder$SentryReplayGestureRecorder;", "Lio/sentry/android/replay/util/FixedWindowCallback;", "options", "Lio/sentry/SentryOptions;", "touchRecorderCallback", "Lio/sentry/android/replay/TouchRecorderCallback;", "delegate", "Landroid/view/Window$Callback;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/TouchRecorderCallback;Landroid/view/Window$Callback;)V", "dispatchTouchEvent", "", "event", "Landroid/view/MotionEvent;", "sentry-android-replay_release"})
    private static final class SentryReplayGestureRecorder
    extends FixedWindowCallback {
        @NotNull
        private final SentryOptions options;
        @Nullable
        private final TouchRecorderCallback touchRecorderCallback;

        public SentryReplayGestureRecorder(@NotNull SentryOptions options, @Nullable TouchRecorderCallback touchRecorderCallback, @Nullable Window.Callback delegate) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super(delegate);
            this.options = options;
            this.touchRecorderCallback = touchRecorderCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean dispatchTouchEvent(@Nullable MotionEvent event) {
            if (event != null) {
                MotionEvent motionEvent = MotionEvent.obtainNoHistory((MotionEvent)event);
                Intrinsics.checkNotNullExpressionValue((Object)motionEvent, (String)"obtainNoHistory(event)");
                MotionEvent copy = motionEvent;
                try {
                    TouchRecorderCallback touchRecorderCallback = this.touchRecorderCallback;
                    if (touchRecorderCallback != null) {
                        touchRecorderCallback.onTouchEvent(copy);
                    }
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error dispatching touch event", e);
                }
                finally {
                    copy.recycle();
                }
            }
            return super.dispatchTouchEvent(event);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/WindowRecorder$Companion;", "", "()V", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/WindowRecorder$RecorderExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class RecorderExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryWindowRecorder-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

