/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ScreenshotRecorder;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowsKt;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.android.replay.util.MainLooperHandler;
import io.sentry.android.replay.util.ViewsKt;
import io.sentry.android.replay.viewhierarchy.ViewHierarchyNode;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001;B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\"J\u0006\u00101\u001a\u00020/J\u0006\u00102\u001a\u00020/J\b\u00103\u001a\u00020/H\u0016J\u0006\u00104\u001a\u00020/J\u0006\u00105\u001a\u00020/J\u0010\u00106\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\"J\u0014\u00107\u001a\u000208*\u00020$2\u0006\u00109\u001a\u00020:H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010%\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0018\u001a\u0004\b&\u0010'R\u001b\u0010)\u001a\u00020*8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0018\u001a\u0004\b+\u0010,\u00a8\u0006<"}, d2={"Lio/sentry/android/replay/ScreenshotRecorder;", "Landroid/view/ViewTreeObserver$OnDrawListener;", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "options", "Lio/sentry/SentryOptions;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "recorder", "Ljava/util/concurrent/ScheduledExecutorService;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "(Lio/sentry/android/replay/ScreenshotRecorderConfig;Lio/sentry/SentryOptions;Lio/sentry/android/replay/util/MainLooperHandler;Ljava/util/concurrent/ScheduledExecutorService;Lio/sentry/android/replay/ScreenshotRecorderCallback;)V", "getConfig", "()Lio/sentry/android/replay/ScreenshotRecorderConfig;", "contentChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isCapturing", "lastCaptureSuccessful", "maskingPaint", "Landroid/graphics/Paint;", "getMaskingPaint", "()Landroid/graphics/Paint;", "maskingPaint$delegate", "Lkotlin/Lazy;", "getOptions", "()Lio/sentry/SentryOptions;", "prescaledMatrix", "Landroid/graphics/Matrix;", "getPrescaledMatrix", "()Landroid/graphics/Matrix;", "prescaledMatrix$delegate", "rootView", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "screenshot", "Landroid/graphics/Bitmap;", "singlePixelBitmap", "getSinglePixelBitmap", "()Landroid/graphics/Bitmap;", "singlePixelBitmap$delegate", "singlePixelBitmapCanvas", "Landroid/graphics/Canvas;", "getSinglePixelBitmapCanvas", "()Landroid/graphics/Canvas;", "singlePixelBitmapCanvas$delegate", "bind", "", "root", "capture", "close", "onDraw", "pause", "resume", "unbind", "dominantColorForRect", "", "rect", "Landroid/graphics/Rect;", "RecorderExecutorServiceThreadFactory", "sentry-android-replay_release"})
@TargetApi(value=26)
public final class ScreenshotRecorder
implements ViewTreeObserver.OnDrawListener {
    @NotNull
    private final ScreenshotRecorderConfig config;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final MainLooperHandler mainLooperHandler;
    @NotNull
    private final ScheduledExecutorService recorder;
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @Nullable
    private WeakReference<View> rootView;
    @NotNull
    private final Lazy maskingPaint$delegate;
    @NotNull
    private final Lazy singlePixelBitmap$delegate;
    @NotNull
    private final Bitmap screenshot;
    @NotNull
    private final Lazy singlePixelBitmapCanvas$delegate;
    @NotNull
    private final Lazy prescaledMatrix$delegate;
    @NotNull
    private final AtomicBoolean contentChanged;
    @NotNull
    private final AtomicBoolean isCapturing;
    @NotNull
    private final AtomicBoolean lastCaptureSuccessful;

    public ScreenshotRecorder(@NotNull ScreenshotRecorderConfig config, @NotNull SentryOptions options, @NotNull MainLooperHandler mainLooperHandler, @NotNull ScheduledExecutorService recorder, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)mainLooperHandler, (String)"mainLooperHandler");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        this.config = config;
        this.options = options;
        this.mainLooperHandler = mainLooperHandler;
        this.recorder = recorder;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.maskingPaint$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)maskingPaint.2.INSTANCE);
        this.singlePixelBitmap$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)singlePixelBitmap.2.INSTANCE);
        Bitmap bitmap = Bitmap.createBitmap((int)this.config.getRecordingWidth(), (int)this.config.getRecordingHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(\n        co\u2026tmap.Config.RGB_565\n    )");
        this.screenshot = bitmap;
        this.singlePixelBitmapCanvas$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Canvas>(this){
            final /* synthetic */ ScreenshotRecorder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Canvas invoke() {
                return new Canvas(ScreenshotRecorder.access$getSinglePixelBitmap(this.this$0));
            }
        }));
        this.prescaledMatrix$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Matrix>(this){
            final /* synthetic */ ScreenshotRecorder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Matrix invoke() {
                Matrix matrix = new Matrix();
                ScreenshotRecorder screenshotRecorder = this.this$0;
                Matrix $this$invoke_u24lambda_u240 = matrix;
                boolean bl = false;
                $this$invoke_u24lambda_u240.preScale(screenshotRecorder.getConfig().getScaleFactorX(), screenshotRecorder.getConfig().getScaleFactorY());
                return matrix;
            }
        }));
        this.contentChanged = new AtomicBoolean(false);
        this.isCapturing = new AtomicBoolean(true);
        this.lastCaptureSuccessful = new AtomicBoolean(false);
    }

    @NotNull
    public final ScreenshotRecorderConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final SentryOptions getOptions() {
        return this.options;
    }

    private final Paint getMaskingPaint() {
        Lazy lazy = this.maskingPaint$delegate;
        return (Paint)lazy.getValue();
    }

    private final Bitmap getSinglePixelBitmap() {
        Lazy lazy = this.singlePixelBitmap$delegate;
        return (Bitmap)lazy.getValue();
    }

    private final Canvas getSinglePixelBitmapCanvas() {
        Lazy lazy = this.singlePixelBitmapCanvas$delegate;
        return (Canvas)lazy.getValue();
    }

    private final Matrix getPrescaledMatrix() {
        Lazy lazy = this.prescaledMatrix$delegate;
        return (Matrix)lazy.getValue();
    }

    public final void capture() {
        View root;
        if (!this.isCapturing.get()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "ScreenshotRecorder is paused, not capturing screenshot", new Object[0]);
            return;
        }
        if (!this.contentChanged.get() && this.lastCaptureSuccessful.get()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Content hasn't changed, repeating last known frame", new Object[0]);
            ScreenshotRecorderCallback screenshotRecorderCallback = this.screenshotRecorderCallback;
            if (screenshotRecorderCallback != null) {
                screenshotRecorderCallback.onScreenshotRecorded(this.screenshot);
            }
            return;
        }
        WeakReference<View> weakReference = this.rootView;
        Object object = root = weakReference != null ? (View)weakReference.get() : null;
        if (root == null || root.getWidth() <= 0 || root.getHeight() <= 0 || !root.isShown()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Root view is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        Window window = WindowsKt.getPhoneWindow(root);
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        this.mainLooperHandler.post(() -> ScreenshotRecorder.capture$lambda$2(this, window, root));
    }

    public void onDraw() {
        View root;
        WeakReference<View> weakReference = this.rootView;
        Object object = root = weakReference != null ? (View)weakReference.get() : null;
        if (root == null || root.getWidth() <= 0 || root.getHeight() <= 0 || !root.isShown()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Root view is invalid, not capturing screenshot", new Object[0]);
            return;
        }
        this.contentChanged.set(true);
    }

    public final void bind(@NotNull View root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
        WeakReference<View> weakReference2 = this.rootView;
        if (weakReference2 != null) {
            weakReference2.clear();
        }
        this.rootView = new WeakReference<View>(root);
        ViewsKt.addOnDrawListenerSafe(root, this);
        this.contentChanged.set(true);
    }

    public final void unbind(@Nullable View root) {
        block0: {
            View view = root;
            if (view == null) break block0;
            ViewsKt.removeOnDrawListenerSafe(view, this);
        }
    }

    public final void pause() {
        this.isCapturing.set(false);
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
    }

    public final void resume() {
        View view = this.rootView;
        if (view != null && (view = (View)view.get()) != null) {
            ViewsKt.addOnDrawListenerSafe(view, this);
        }
        this.isCapturing.set(true);
    }

    public final void close() {
        WeakReference<View> weakReference = this.rootView;
        this.unbind((View)(weakReference != null ? (View)weakReference.get() : null));
        WeakReference<View> weakReference2 = this.rootView;
        if (weakReference2 != null) {
            weakReference2.clear();
        }
        this.screenshot.recycle();
        this.isCapturing.set(false);
    }

    private final int dominantColorForRect(Bitmap $this$dominantColorForRect, Rect rect) {
        Rect visibleRect = new Rect(rect);
        RectF visibleRectF = new RectF(visibleRect);
        this.getPrescaledMatrix().mapRect(visibleRectF);
        visibleRectF.round(visibleRect);
        this.getSinglePixelBitmapCanvas().drawBitmap($this$dominantColorForRect, visibleRect, new Rect(0, 0, 1, 1), null);
        return this.getSinglePixelBitmap().getPixel(0, 0);
    }

    private static final void capture$lambda$2$lambda$1$lambda$0(ScreenshotRecorder this$0, ViewHierarchyNode $viewHierarchy) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$viewHierarchy, (String)"$viewHierarchy");
        Canvas canvas = new Canvas(this$0.screenshot);
        canvas.setMatrix(this$0.getPrescaledMatrix());
        $viewHierarchy.traverse((Function1<? super ViewHierarchyNode, Boolean>)((Function1)new Function1<ViewHierarchyNode, Boolean>(this$0, canvas){
            final /* synthetic */ ScreenshotRecorder this$0;
            final /* synthetic */ Canvas $canvas;
            {
                this.this$0 = $receiver;
                this.$canvas = $canvas;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull ViewHierarchyNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getShouldMask() && node.getWidth() > 0 && node.getHeight() > 0) {
                    void $this$forEach$iv;
                    Pair pair;
                    if (node.getVisibleRect() == null) {
                        return false;
                    }
                    ViewHierarchyNode viewHierarchyNode = node;
                    if (viewHierarchyNode instanceof ViewHierarchyNode.ImageViewHierarchyNode) {
                        pair = TuplesKt.to((Object)CollectionsKt.listOf((Object)node.getVisibleRect()), (Object)ScreenshotRecorder.access$dominantColorForRect(this.this$0, ScreenshotRecorder.access$getScreenshot$p(this.this$0), node.getVisibleRect()));
                    } else if (viewHierarchyNode instanceof ViewHierarchyNode.TextViewHierarchyNode) {
                        int n;
                        Object object = ((ViewHierarchyNode.TextViewHierarchyNode)node).getLayout();
                        if (object != null && (object = object.getDominantTextColor()) != null) {
                            n = (Integer)object;
                        } else {
                            Integer n2 = ((ViewHierarchyNode.TextViewHierarchyNode)node).getDominantColor();
                            n = n2 != null ? n2 : -16777216;
                        }
                        int textColor = n;
                        pair = TuplesKt.to(ViewsKt.getVisibleRects(((ViewHierarchyNode.TextViewHierarchyNode)node).getLayout(), node.getVisibleRect(), ((ViewHierarchyNode.TextViewHierarchyNode)node).getPaddingLeft(), ((ViewHierarchyNode.TextViewHierarchyNode)node).getPaddingTop()), (Object)textColor);
                    } else {
                        pair = TuplesKt.to((Object)CollectionsKt.listOf((Object)node.getVisibleRect()), (Object)-16777216);
                    }
                    Pair pair2 = pair;
                    List visibleRects = (List)pair2.component1();
                    int color = ((Number)pair2.component2()).intValue();
                    ScreenshotRecorder.access$getMaskingPaint(this.this$0).setColor(color);
                    Iterable iterable = visibleRects;
                    Canvas canvas = this.$canvas;
                    ScreenshotRecorder screenshotRecorder = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Rect rect = (Rect)element$iv;
                        boolean bl = false;
                        canvas.drawRoundRect(new RectF(rect), 10.0f, 10.0f, ScreenshotRecorder.access$getMaskingPaint(screenshotRecorder));
                    }
                }
                return true;
            }
        }));
        ScreenshotRecorderCallback screenshotRecorderCallback = this$0.screenshotRecorderCallback;
        if (screenshotRecorderCallback != null) {
            screenshotRecorderCallback.onScreenshotRecorded(this$0.screenshot);
        }
        this$0.lastCaptureSuccessful.set(true);
        this$0.contentChanged.set(false);
    }

    private static final void capture$lambda$2$lambda$1(ScreenshotRecorder this$0, View $root, int copyResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (copyResult != 0) {
            Object[] objectArray = new Object[]{copyResult};
            this$0.options.getLogger().log(SentryLevel.INFO, "Failed to capture replay recording: %d", objectArray);
            this$0.lastCaptureSuccessful.set(false);
            return;
        }
        if (this$0.contentChanged.get()) {
            this$0.options.getLogger().log(SentryLevel.INFO, "Failed to determine view hierarchy, not capturing", new Object[0]);
            this$0.lastCaptureSuccessful.set(false);
            return;
        }
        ViewHierarchyNode viewHierarchy = ViewHierarchyNode.Companion.fromView($root, null, 0, this$0.options);
        ViewsKt.traverse($root, viewHierarchy, this$0.options);
        ExecutorsKt.submitSafely(this$0.recorder, this$0.options, "screenshot_recorder.mask", () -> ScreenshotRecorder.capture$lambda$2$lambda$1$lambda$0(this$0, viewHierarchy));
    }

    private static final void capture$lambda$2(ScreenshotRecorder this$0, Window $window, View $root) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.contentChanged.set(false);
            PixelCopy.request((Window)$window, (Bitmap)this$0.screenshot, arg_0 -> ScreenshotRecorder.capture$lambda$2$lambda$1(this$0, $root, arg_0), (Handler)this$0.mainLooperHandler.getHandler());
        }
        catch (Throwable e) {
            this$0.options.getLogger().log(SentryLevel.WARNING, "Failed to capture replay recording", e);
            this$0.lastCaptureSuccessful.set(false);
        }
    }

    public static final /* synthetic */ int access$dominantColorForRect(ScreenshotRecorder $this, Bitmap $receiver, Rect rect) {
        return $this.dominantColorForRect($receiver, rect);
    }

    public static final /* synthetic */ Bitmap access$getScreenshot$p(ScreenshotRecorder $this) {
        return $this.screenshot;
    }

    public static final /* synthetic */ Paint access$getMaskingPaint(ScreenshotRecorder $this) {
        return $this.getMaskingPaint();
    }

    public static final /* synthetic */ Bitmap access$getSinglePixelBitmap(ScreenshotRecorder $this) {
        return $this.getSinglePixelBitmap();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/sentry/android/replay/ScreenshotRecorder$RecorderExecutorServiceThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "cnt", "", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "sentry-android-replay_release"})
    private static final class RecorderExecutorServiceThreadFactory
    implements ThreadFactory {
        private int cnt;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            int n = this.cnt;
            this.cnt = n + 1;
            Thread ret = new Thread(r, "SentryReplayRecorder-" + n);
            ret.setDaemon(true);
            return ret;
        }
    }
}

