/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport.apache;

import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.RequestDetails;
import io.sentry.SentryDate;
import io.sentry.SentryEnvelope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.clientreport.DiscardReason;
import io.sentry.hints.Retryable;
import io.sentry.transport.ITransport;
import io.sentry.transport.RateLimiter;
import io.sentry.transport.ReusableCountLatch;
import io.sentry.util.HintUtils;
import io.sentry.util.Objects;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequests;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.TimeValue;
import org.jetbrains.annotations.NotNull;

public final class ApacheHttpClientTransport
implements ITransport {
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final RequestDetails requestDetails;
    @NotNull
    private final CloseableHttpAsyncClient httpclient;
    @NotNull
    private final RateLimiter rateLimiter;
    @NotNull
    private final ReusableCountLatch currentlyRunning;

    public ApacheHttpClientTransport(@NotNull SentryOptions options, @NotNull RequestDetails requestDetails, @NotNull CloseableHttpAsyncClient httpclient, @NotNull RateLimiter rateLimiter) {
        this(options, requestDetails, httpclient, rateLimiter, new ReusableCountLatch());
    }

    ApacheHttpClientTransport(@NotNull SentryOptions options, @NotNull RequestDetails requestDetails, @NotNull CloseableHttpAsyncClient httpclient, @NotNull RateLimiter rateLimiter, @NotNull ReusableCountLatch currentlyRunning) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options is required");
        this.requestDetails = (RequestDetails)Objects.requireNonNull((Object)requestDetails, (String)"requestDetails is required");
        this.httpclient = (CloseableHttpAsyncClient)Objects.requireNonNull((Object)httpclient, (String)"httpclient is required");
        this.rateLimiter = (RateLimiter)Objects.requireNonNull((Object)rateLimiter, (String)"rateLimiter is required");
        this.currentlyRunning = (ReusableCountLatch)Objects.requireNonNull((Object)currentlyRunning, (String)"currentlyRunning is required");
        this.httpclient.start();
    }

    public void send(@NotNull SentryEnvelope envelope, final @NotNull Hint hint) throws IOException {
        if (this.isSchedulingAllowed()) {
            SentryEnvelope envelopeWithClientReport;
            SentryEnvelope filteredEnvelope = this.rateLimiter.filter(envelope, hint);
            if (filteredEnvelope != null && (envelopeWithClientReport = this.options.getClientReportRecorder().attachReportToEnvelope(filteredEnvelope)) != null) {
                @NotNull SentryDate now = this.options.getDateProvider().now();
                envelopeWithClientReport.getHeader().setSentAt(DateUtils.nanosToDate((long)now.nanoTimestamp()));
                this.currentlyRunning.increment();
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                     GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
                    this.options.getSerializer().serialize(envelopeWithClientReport, (OutputStream)gzip);
                    SimpleHttpRequest request = SimpleHttpRequests.post((String)this.requestDetails.getUrl().toString());
                    request.setBody(outputStream.toByteArray(), ContentType.create((String)"application/x-sentry-envelope"));
                    request.setHeader("Content-Encoding", (Object)"gzip");
                    request.setHeader("Accept", (Object)"application/json");
                    for (Map.Entry header : this.requestDetails.getHeaders().entrySet()) {
                        request.setHeader((String)header.getKey(), header.getValue());
                    }
                    if (this.options.getLogger().isEnabled(SentryLevel.DEBUG)) {
                        this.options.getLogger().log(SentryLevel.DEBUG, "Currently running %d requests", new Object[]{this.currentlyRunning.getCount()});
                    }
                    this.httpclient.execute(request, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                        public void completed(SimpleHttpResponse response) {
                            if (response.getCode() != 200) {
                                ApacheHttpClientTransport.this.options.getLogger().log(SentryLevel.ERROR, "Request failed, API returned %s", new Object[]{response.getCode()});
                                if (response.getCode() >= 400 && response.getCode() != 429 && !HintUtils.hasType((Hint)hint, Retryable.class)) {
                                    ApacheHttpClientTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, envelopeWithClientReport);
                                }
                            } else {
                                ApacheHttpClientTransport.this.options.getLogger().log(SentryLevel.INFO, "Envelope sent successfully.", new Object[0]);
                            }
                            Header retryAfter = response.getFirstHeader("Retry-After");
                            Header rateLimits = response.getFirstHeader("X-Sentry-Rate-Limits");
                            ApacheHttpClientTransport.this.rateLimiter.updateRetryAfterLimits(rateLimits != null ? rateLimits.getValue() : null, retryAfter != null ? retryAfter.getValue() : null, response.getCode());
                            ApacheHttpClientTransport.this.currentlyRunning.decrement();
                        }

                        public void failed(Exception ex) {
                            ApacheHttpClientTransport.this.options.getLogger().log(SentryLevel.ERROR, "Error while sending an envelope", (Throwable)ex);
                            if (!HintUtils.hasType((Hint)hint, Retryable.class)) {
                                ApacheHttpClientTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, envelopeWithClientReport);
                            }
                            ApacheHttpClientTransport.this.currentlyRunning.decrement();
                        }

                        public void cancelled() {
                            ApacheHttpClientTransport.this.options.getLogger().log(SentryLevel.WARNING, "Request cancelled", new Object[0]);
                            if (!HintUtils.hasType((Hint)hint, Retryable.class)) {
                                ApacheHttpClientTransport.this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, envelopeWithClientReport);
                            }
                            ApacheHttpClientTransport.this.currentlyRunning.decrement();
                        }
                    });
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error when sending envelope", e);
                    if (!HintUtils.hasType((Hint)hint, Retryable.class)) {
                        this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.NETWORK_ERROR, envelopeWithClientReport);
                    }
                }
            }
        } else {
            this.options.getLogger().log(SentryLevel.WARNING, "Submit cancelled", new Object[0]);
            this.options.getClientReportRecorder().recordLostEnvelope(DiscardReason.QUEUE_OVERFLOW, envelope);
        }
    }

    public void flush(long timeoutMillis) {
        try {
            if (!this.currentlyRunning.waitTillZero(timeoutMillis, TimeUnit.MILLISECONDS)) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to flush all events within %s ms", new Object[]{timeoutMillis});
            }
        }
        catch (InterruptedException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to flush events", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void close() throws IOException {
        this.options.getLogger().log(SentryLevel.DEBUG, "Shutting down", new Object[0]);
        try {
            this.httpclient.awaitShutdown(TimeValue.ofSeconds((long)1L));
        }
        catch (InterruptedException e) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Thread interrupted while closing the connection.", new Object[0]);
            Thread.currentThread().interrupt();
        }
        finally {
            this.httpclient.close(CloseMode.GRACEFUL);
        }
    }

    private boolean isSchedulingAllowed() {
        return this.currentlyRunning.getCount() < this.options.getMaxQueueSize();
    }
}

