/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport.apache;

import io.sentry.ITransportFactory;
import io.sentry.RequestDetails;
import io.sentry.SentryOptions;
import io.sentry.transport.ITransport;
import io.sentry.transport.RateLimiter;
import io.sentry.transport.apache.ApacheHttpClientTransport;
import io.sentry.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.util.TimeValue;
import org.jetbrains.annotations.NotNull;

public final class ApacheHttpClientTransportFactory
implements ITransportFactory {
    @NotNull
    private final TimeValue connectionTimeToLive;

    public ApacheHttpClientTransportFactory() {
        this(TimeValue.ofMinutes((long)1L));
    }

    public ApacheHttpClientTransportFactory(@NotNull TimeValue connectionTimeToLive) {
        this.connectionTimeToLive = (TimeValue)Objects.requireNonNull((Object)connectionTimeToLive, (String)"connectionTimeToLive is required");
    }

    @NotNull
    public ITransport create(@NotNull SentryOptions options, @NotNull RequestDetails requestDetails) {
        Objects.requireNonNull((Object)options, (String)"options is required");
        Objects.requireNonNull((Object)requestDetails, (String)"requestDetails is required");
        PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setPoolConcurrencyPolicy(PoolConcurrencyPolicy.LAX).setConnectionTimeToLive(this.connectionTimeToLive).setMaxConnTotal(options.getMaxQueueSize()).setMaxConnPerRoute(options.getMaxQueueSize()).build();
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setConnectionManager((AsyncClientConnectionManager)connectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout((long)options.getConnectionTimeoutMillis(), TimeUnit.MILLISECONDS).setConnectionRequestTimeout((long)options.getConnectionTimeoutMillis(), TimeUnit.MILLISECONDS).setResponseTimeout((long)options.getReadTimeoutMillis(), TimeUnit.MILLISECONDS).build()).build();
        RateLimiter rateLimiter = new RateLimiter(options);
        return new ApacheHttpClientTransport(options, requestDetails, httpclient, rateLimiter);
    }
}

