/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.log4j;

import io.sentry.Sentry;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.StackTraceInterface;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class SentryAppender
extends AppenderSkeleton {
    public static final String LOG4J_NDC = "log4J-NDC";
    public static final String THREAD_NAME = "Sentry-Threadname";

    public SentryAppender() {
        this.addFilter(new DropSentryFilter());
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual((Priority)Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected static StackTraceElement asStackTraceElement(LocationInfo location) {
        String fileName = "?".equals(location.getFileName()) ? null : location.getFileName();
        int line = "?".equals(location.getLineNumber()) ? -1 : Integer.parseInt(location.getLineNumber());
        return new StackTraceElement(location.getClassName(), location.getMethodName(), fileName, line);
    }

    protected void append(LoggingEvent loggingEvent) {
        if (SentryEnvironment.isManagingThread()) {
            return;
        }
        SentryEnvironment.startManagingThread();
        try {
            EventBuilder eventBuilder = this.createEventBuilder(loggingEvent);
            Sentry.capture((EventBuilder)eventBuilder);
        }
        catch (RuntimeException e) {
            this.getErrorHandler().error("An exception occurred while creating a new event in Sentry", (Exception)e, 1);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    protected EventBuilder createEventBuilder(LoggingEvent loggingEvent) {
        LocationInfo location;
        EventBuilder eventBuilder = new EventBuilder().withSdkIntegration("log4j").withTimestamp(new Date(loggingEvent.getTimeStamp())).withMessage(loggingEvent.getRenderedMessage()).withLogger(loggingEvent.getLoggerName()).withLevel(SentryAppender.formatLevel(loggingEvent.getLevel())).withExtra(THREAD_NAME, (Object)loggingEvent.getThreadName());
        ThrowableInformation throwableInformation = null;
        try {
            throwableInformation = loggingEvent.getThrowableInformation();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (throwableInformation != null) {
            Throwable throwable = throwableInformation.getThrowable();
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (loggingEvent.getLocationInformation().fullInfo != null && !"?".equals((location = loggingEvent.getLocationInformation()).getFileName()) && !"?".equals(location.getLineNumber())) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{SentryAppender.asStackTraceElement(location)};
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(stackTrace));
        }
        if (loggingEvent.getNDC() != null) {
            eventBuilder.withExtra(LOG4J_NDC, (Object)loggingEvent.getNDC());
        }
        Set extraTags = Sentry.getStoredClient().getMdcTags();
        Map properties = loggingEvent.getProperties();
        for (Map.Entry mdcEntry : properties.entrySet()) {
            if (extraTags.contains(mdcEntry.getKey())) {
                eventBuilder.withTag((String)mdcEntry.getKey(), mdcEntry.getValue().toString());
                continue;
            }
            eventBuilder.withExtra((String)mdcEntry.getKey(), mdcEntry.getValue());
        }
        return eventBuilder;
    }

    public void close() {
        SentryEnvironment.startManagingThread();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Sentry.close();
        }
        catch (RuntimeException e) {
            this.getErrorHandler().error("An exception occurred while closing the Sentry connection", (Exception)e, 3);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    private class DropSentryFilter
    extends Filter {
        private DropSentryFilter() {
        }

        public int decide(LoggingEvent event) {
            String loggerName = event.getLoggerName();
            if (loggerName != null && loggerName.startsWith("io.sentry")) {
                return -1;
            }
            return 0;
        }
    }
}

