/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.log4j2;

import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.config.Lookup;
import io.sentry.dsn.Dsn;
import io.sentry.dsn.InvalidDsnException;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.MessageInterface;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.StackTraceInterface;
import io.sentry.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="Sentry", category="Core", elementType="appender", printObject=true)
public class SentryAppender
extends AbstractAppender {
    public static final String APPENDER_NAME = "sentry";
    public static final String LOG4J_NDC = "log4j2-NDC";
    public static final String LOG4J_MARKER = "log4j2-Marker";
    public static final String THREAD_NAME = "Sentry-Threadname";
    protected volatile SentryClient sentryClient;
    protected Dsn dsn;
    protected String sentryClientFactory;
    protected String release;
    protected String dist;
    protected String environment;
    protected String serverName;
    protected Map<String, String> tags = Collections.emptyMap();
    protected Set<String> extraTags = Collections.emptySet();
    private volatile boolean initialized = false;

    public SentryAppender() {
        this(APPENDER_NAME, null);
    }

    public SentryAppender(SentryClient sentryClient) {
        this();
        this.sentryClient = sentryClient;
    }

    protected SentryAppender(String name, Filter filter) {
        super(name, filter, null, true);
        this.addFilter((Filter)new DropSentryFilter());
    }

    @PluginFactory
    public static SentryAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="dsn") String dsn, @PluginAttribute(value="factory") String factory, @PluginAttribute(value="release") String release, @PluginAttribute(value="dist") String dist, @PluginAttribute(value="environment") String environment, @PluginAttribute(value="serverName") String serverName, @PluginAttribute(value="tags") String tags, @PluginAttribute(value="extraTags") String extraTags, @PluginElement(value="filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for SentryAppender");
            return null;
        }
        SentryAppender sentryAppender = new SentryAppender(name, filter);
        sentryAppender.setDsn(dsn);
        if (release != null) {
            sentryAppender.setRelease(release);
        }
        if (dist != null) {
            sentryAppender.setDist(dist);
        }
        if (environment != null) {
            sentryAppender.setEnvironment(environment);
        }
        if (serverName != null) {
            sentryAppender.setServerName(serverName);
        }
        if (tags != null) {
            sentryAppender.setTags(tags);
        }
        if (extraTags != null) {
            sentryAppender.setExtraTags(extraTags);
        }
        sentryAppender.setFactory(factory);
        return sentryAppender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (!this.initialized) {
            SentryAppender sentryAppender = this;
            synchronized (sentryAppender) {
                if (!this.initialized) {
                    try {
                        String extraTags;
                        String tags;
                        String serverName;
                        String environment;
                        String dist;
                        String release;
                        String sentryClientFactory = Lookup.lookup((String)"factory");
                        if (sentryClientFactory != null) {
                            this.setFactory(sentryClientFactory);
                        }
                        if ((release = Lookup.lookup((String)"release")) != null) {
                            this.setRelease(release);
                        }
                        if ((dist = Lookup.lookup((String)"dist")) != null) {
                            this.setDist(dist);
                        }
                        if ((environment = Lookup.lookup((String)"environment")) != null) {
                            this.setEnvironment(environment);
                        }
                        if ((serverName = Lookup.lookup((String)"serverName")) != null) {
                            this.setServerName(serverName);
                        }
                        if ((tags = Lookup.lookup((String)"tags")) != null) {
                            this.setTags(tags);
                        }
                        if ((extraTags = Lookup.lookup((String)"extraTags")) != null) {
                            this.setExtraTags(extraTags);
                        }
                    }
                    finally {
                        this.initialized = true;
                    }
                }
            }
        }
        if (this.sentryClient == null) {
            this.initSentry();
        }
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isMoreSpecificThan(Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            return Event.Level.INFO;
        }
        return Event.Level.DEBUG;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> stringParameters = new ArrayList<String>(parameters.length);
        for (Object parameter : parameters) {
            stringParameters.add(parameter != null ? parameter.toString() : null);
        }
        return stringParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent logEvent) {
        if (SentryEnvironment.isManagingThread()) {
            return;
        }
        SentryEnvironment.startManagingThread();
        try {
            this.lazyInit();
            Event event = this.buildEvent(logEvent);
            this.sentryClient.sendEvent(event);
        }
        catch (Exception e) {
            this.error("An exception occurred while creating a new event in Sentry", logEvent, e);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    protected synchronized void initSentry() {
        try {
            this.sentryClient = SentryClientFactory.sentryClient((Dsn)this.dsn, (String)this.sentryClientFactory);
        }
        catch (InvalidDsnException e) {
            this.error("An exception occurred during the retrieval of the DSN for Sentry", e);
        }
        catch (Exception e) {
            this.error("An exception occurred during the creation of a SentryClient instance", e);
        }
    }

    protected Event buildEvent(LogEvent event) {
        Throwable throwable;
        Message eventMessage = event.getMessage();
        EventBuilder eventBuilder = new EventBuilder().withSdkName("sentry-java:log4j2").withTimestamp(new Date(event.getTimeMillis())).withMessage(eventMessage.getFormattedMessage()).withLogger(event.getLoggerName()).withLevel(SentryAppender.formatLevel(event.getLevel())).withExtra(THREAD_NAME, (Object)event.getThreadName());
        if (!Util.isNullOrEmpty((String)this.serverName)) {
            eventBuilder.withServerName(this.serverName.trim());
        }
        if (!Util.isNullOrEmpty((String)this.release)) {
            eventBuilder.withRelease(this.release.trim());
            if (!Util.isNullOrEmpty((String)this.dist)) {
                eventBuilder.withDist(this.dist.trim());
            }
        }
        if (!Util.isNullOrEmpty((String)this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        if (eventMessage.getFormat() != null && !eventMessage.getFormat().equals("") && !eventMessage.getFormattedMessage().equals(eventMessage.getFormat())) {
            eventBuilder.withSentryInterface((SentryInterface)new MessageInterface(eventMessage.getFormat(), SentryAppender.formatMessageParameters(eventMessage.getParameters()), eventMessage.getFormattedMessage()));
        }
        if ((throwable = event.getThrown()) != null) {
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (event.getSource() != null) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{event.getSource()};
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(stackTrace));
        }
        if (event.getSource() != null) {
            eventBuilder.withCulprit(event.getSource());
        } else {
            eventBuilder.withCulprit(event.getLoggerName());
        }
        if (event.getContextStack() != null) {
            eventBuilder.withExtra(LOG4J_NDC, (Object)event.getContextStack().asList());
        }
        Set clientExtraTags = this.sentryClient.getExtraTags();
        if (event.getContextMap() != null) {
            for (Map.Entry<Object, Object> entry : event.getContextMap().entrySet()) {
                if (this.extraTags.contains(entry.getKey()) || clientExtraTags.contains(entry.getKey())) {
                    eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                eventBuilder.withExtra((String)entry.getKey(), entry.getValue());
            }
        }
        if (event.getMarker() != null) {
            eventBuilder.withTag(LOG4J_MARKER, event.getMarker().getName());
        }
        for (Map.Entry<Object, Object> entry : this.tags.entrySet()) {
            eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
        }
        this.sentryClient.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    public void setDsn(String dsn) {
        if (!Util.isNullOrEmpty((String)dsn)) {
            this.dsn = new Dsn(dsn);
        }
    }

    public void setFactory(String factory) {
        this.sentryClientFactory = factory;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setDist(String dist) {
        this.dist = dist;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setTags(String tags) {
        this.tags = Util.parseTags((String)tags);
    }

    public void setExtraTags(String extraTags) {
        this.extraTags = Util.parseExtraTags((String)extraTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SentryEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            if (this.sentryClient != null) {
                this.sentryClient.closeConnection();
            }
        }
        catch (Exception e) {
            this.error("An exception occurred while closing the Sentry connection", e);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    private class DropSentryFilter
    extends AbstractFilter {
        private DropSentryFilter() {
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(LogEvent event) {
            return this.filter(event.getLoggerName());
        }

        private Filter.Result filter(String loggerName) {
            if (loggerName != null && loggerName.startsWith("io.sentry")) {
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }
    }
}

