/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import io.sentry.Sentry;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.MessageInterface;
import io.sentry.event.interfaces.SentryException;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.StackTraceInterface;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SentryAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    public static final String LOGBACK_MARKER = "logback-Marker";
    public static final String THREAD_NAME = "Sentry-Threadname";
    @Deprecated
    protected volatile Level minLevel;

    public SentryAppender() {
        this.addFilter(new DropSentryFilter());
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> arguments = new ArrayList<String>(parameters.length);
        for (Object argument : parameters) {
            arguments.add(argument != null ? argument.toString() : null);
        }
        return arguments;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual(Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent iLoggingEvent) {
        if (this.isNotLoggable(iLoggingEvent) || SentryEnvironment.isManagingThread()) {
            return;
        }
        SentryEnvironment.startManagingThread();
        try {
            if (this.minLevel != null && !iLoggingEvent.getLevel().isGreaterOrEqual(this.minLevel)) {
                return;
            }
            EventBuilder eventBuilder = this.createEventBuilder(iLoggingEvent);
            Sentry.capture((EventBuilder)eventBuilder);
        }
        catch (Exception e) {
            this.addError("An exception occurred while creating a new event in Sentry", e);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    private boolean isNotLoggable(ILoggingEvent iLoggingEvent) {
        return this.minLevel != null && !iLoggingEvent.getLevel().isGreaterOrEqual(this.minLevel);
    }

    protected EventBuilder createEventBuilder(ILoggingEvent iLoggingEvent) {
        EventBuilder eventBuilder = new EventBuilder().withSdkIntegration("logback").withTimestamp(new Date(iLoggingEvent.getTimeStamp())).withMessage(iLoggingEvent.getFormattedMessage()).withLogger(iLoggingEvent.getLoggerName()).withLevel(SentryAppender.formatLevel(iLoggingEvent.getLevel())).withExtra(THREAD_NAME, (Object)iLoggingEvent.getThreadName());
        if (iLoggingEvent.getArgumentArray() != null) {
            eventBuilder.withSentryInterface((SentryInterface)new MessageInterface(iLoggingEvent.getMessage(), SentryAppender.formatMessageParameters(iLoggingEvent.getArgumentArray()), iLoggingEvent.getFormattedMessage()));
        }
        if (iLoggingEvent.getThrowableProxy() != null) {
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(this.extractExceptionQueue(iLoggingEvent)));
        } else if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(iLoggingEvent.getCallerData()));
        }
        for (Map.Entry contextEntry : iLoggingEvent.getLoggerContextVO().getPropertyMap().entrySet()) {
            eventBuilder.withExtra((String)contextEntry.getKey(), contextEntry.getValue());
        }
        for (Map.Entry mdcEntry : iLoggingEvent.getMDCPropertyMap().entrySet()) {
            if (Sentry.getStoredClient().getMdcTags().contains(mdcEntry.getKey())) {
                eventBuilder.withTag((String)mdcEntry.getKey(), (String)mdcEntry.getValue());
                continue;
            }
            eventBuilder.withExtra((String)mdcEntry.getKey(), mdcEntry.getValue());
        }
        if (iLoggingEvent.getMarker() != null) {
            eventBuilder.withTag(LOGBACK_MARKER, iLoggingEvent.getMarker().getName());
        }
        return eventBuilder;
    }

    protected Deque<SentryException> extractExceptionQueue(ILoggingEvent iLoggingEvent) {
        ArrayDeque<SentryException> exceptions = new ArrayDeque<SentryException>();
        HashSet<IThrowableProxy> circularityDetector = new HashSet<IThrowableProxy>();
        StackTraceElement[] enclosingStackTrace = new StackTraceElement[]{};
        for (IThrowableProxy throwableProxy = iLoggingEvent.getThrowableProxy(); throwableProxy != null; throwableProxy = throwableProxy.getCause()) {
            if (!circularityDetector.add(throwableProxy)) {
                this.addWarn("Exiting a circular exception!");
                break;
            }
            StackTraceElement[] stackTraceElements = this.toStackTraceElements(throwableProxy);
            StackTraceInterface stackTrace = new StackTraceInterface(stackTraceElements, enclosingStackTrace);
            exceptions.push(this.createSentryExceptionFrom(throwableProxy, stackTrace));
            enclosingStackTrace = stackTraceElements;
        }
        return exceptions;
    }

    protected SentryException createSentryExceptionFrom(IThrowableProxy throwableProxy, StackTraceInterface stackTrace) {
        String exceptionMessage = throwableProxy.getMessage();
        String[] packageNameSimpleName = this.extractPackageSimpleClassName(throwableProxy.getClassName());
        String exceptionPackageName = packageNameSimpleName[0];
        String exceptionClassName = packageNameSimpleName[1];
        return new SentryException(exceptionMessage, exceptionClassName, exceptionPackageName, stackTrace);
    }

    protected String[] extractPackageSimpleClassName(String canonicalClassName) {
        String[] packageNameSimpleName = new String[2];
        try {
            Class<?> exceptionClass = Class.forName(canonicalClassName);
            Package exceptionPackage = exceptionClass.getPackage();
            packageNameSimpleName[0] = exceptionPackage != null ? exceptionPackage.getName() : "(default)";
            packageNameSimpleName[1] = exceptionClass.getSimpleName();
        }
        catch (ClassNotFoundException e) {
            int lastDot = canonicalClassName.lastIndexOf(46);
            if (lastDot != -1) {
                packageNameSimpleName[0] = canonicalClassName.substring(0, lastDot);
                packageNameSimpleName[1] = canonicalClassName.substring(lastDot);
            }
            packageNameSimpleName[0] = "(default)";
            packageNameSimpleName[1] = canonicalClassName;
        }
        return packageNameSimpleName;
    }

    protected StackTraceElement[] toStackTraceElements(IThrowableProxy throwableProxy) {
        StackTraceElementProxy[] stackTraceElementProxies = throwableProxy.getStackTraceElementProxyArray();
        StackTraceElement[] stackTraceElements = new StackTraceElement[stackTraceElementProxies.length];
        int stackTraceElementsLength = stackTraceElementProxies.length;
        for (int i = 0; i < stackTraceElementsLength; ++i) {
            stackTraceElements[i] = stackTraceElementProxies[i].getStackTraceElement();
        }
        return stackTraceElements;
    }

    @Deprecated
    public void setMinLevel(String minLevel) {
        this.minLevel = minLevel != null ? Level.toLevel((String)minLevel) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SentryEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            Sentry.close();
        }
        catch (Exception e) {
            this.addError("An exception occurred while closing the Sentry connection", e);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    private class DropSentryFilter
    extends Filter<ILoggingEvent> {
        private DropSentryFilter() {
        }

        public FilterReply decide(ILoggingEvent event) {
            String loggerName = event.getLoggerName();
            if (loggerName != null && loggerName.startsWith("io.sentry")) {
                return FilterReply.DENY;
            }
            return FilterReply.NEUTRAL;
        }
    }
}

