/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.sentry.Breadcrumb;
import io.sentry.DateUtils;
import io.sentry.ITransportFactory;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.protocol.Message;
import io.sentry.protocol.SdkVersion;
import io.sentry.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    @NotNull
    private SentryOptions options = new SentryOptions();
    @Nullable
    private ITransportFactory transportFactory;
    @NotNull
    private Level minimumBreadcrumbLevel = Level.INFO;
    @NotNull
    private Level minimumEventLevel = Level.ERROR;

    public void start() {
        if (!Sentry.isEnabled()) {
            this.options.setEnableExternalConfiguration(true);
            this.options.setSentryClientName("sentry.java.logback");
            this.options.setSdkVersion(this.createSdkVersion(this.options));
            Optional.ofNullable(this.transportFactory).ifPresent(arg_0 -> ((SentryOptions)this.options).setTransportFactory(arg_0));
            try {
                Sentry.init((SentryOptions)this.options);
            }
            catch (IllegalArgumentException e) {
                this.addWarn("Failed to init Sentry during appender initialization: " + e.getMessage());
            }
        }
        super.start();
    }

    protected void append(@NotNull ILoggingEvent eventObject) {
        if (eventObject.getLevel().isGreaterOrEqual(this.minimumEventLevel)) {
            Sentry.captureEvent((SentryEvent)this.createEvent(eventObject));
        }
        if (eventObject.getLevel().isGreaterOrEqual(this.minimumBreadcrumbLevel)) {
            Sentry.addBreadcrumb((Breadcrumb)this.createBreadcrumb(eventObject));
        }
    }

    @NotNull
    final SentryEvent createEvent(@NotNull ILoggingEvent loggingEvent) {
        Map mdcProperties;
        SentryEvent event = new SentryEvent(DateUtils.getDateTime((long)loggingEvent.getTimeStamp()));
        Message message = new Message();
        message.setMessage(loggingEvent.getMessage());
        message.setFormatted(loggingEvent.getFormattedMessage());
        message.setParams(this.toParams(loggingEvent.getArgumentArray()));
        event.setMessage(message);
        event.setLogger(loggingEvent.getLoggerName());
        event.setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        ThrowableProxy throwableInformation = (ThrowableProxy)loggingEvent.getThrowableProxy();
        if (throwableInformation != null) {
            event.setThrowable(throwableInformation.getThrowable());
        }
        if (loggingEvent.getThreadName() != null) {
            event.setExtra("thread_name", (Object)loggingEvent.getThreadName());
        }
        if (!(mdcProperties = CollectionUtils.shallowCopy((Map)loggingEvent.getMDCPropertyMap())).isEmpty()) {
            event.getContexts().put((Object)"MDC", (Object)mdcProperties);
        }
        return event;
    }

    @NotNull
    private List<String> toParams(@Nullable Object[] arguments) {
        if (arguments != null) {
            return Arrays.stream(arguments).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    private Breadcrumb createBreadcrumb(@NotNull ILoggingEvent loggingEvent) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        breadcrumb.setCategory(loggingEvent.getLoggerName());
        breadcrumb.setMessage(loggingEvent.getFormattedMessage());
        return breadcrumb;
    }

    @NotNull
    private static SentryLevel formatLevel(@NotNull Level level) {
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return SentryLevel.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return SentryLevel.WARNING;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return SentryLevel.INFO;
        }
        return SentryLevel.DEBUG;
    }

    @NotNull
    private SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
        SdkVersion sdkVersion = sentryOptions.getSdkVersion();
        if (sdkVersion == null) {
            sdkVersion = new SdkVersion();
        }
        sdkVersion.setName("sentry.java.logback");
        String version = "4.0.0";
        sdkVersion.setVersion("4.0.0");
        sdkVersion.addPackage("maven:sentry-logback", "4.0.0");
        return sdkVersion;
    }

    public void setOptions(@Nullable SentryOptions options) {
        this.options = options;
    }

    public void setMinimumBreadcrumbLevel(@Nullable Level minimumBreadcrumbLevel) {
        if (minimumBreadcrumbLevel != null) {
            this.minimumBreadcrumbLevel = minimumBreadcrumbLevel;
        }
    }

    @NotNull
    public Level getMinimumBreadcrumbLevel() {
        return this.minimumBreadcrumbLevel;
    }

    public void setMinimumEventLevel(@Nullable Level minimumEventLevel) {
        if (minimumEventLevel != null) {
            this.minimumEventLevel = minimumEventLevel;
        }
    }

    @NotNull
    public Level getMinimumEventLevel() {
        return this.minimumEventLevel;
    }

    @ApiStatus.Internal
    void setTransportFactory(@Nullable ITransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }
}

