/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="uploadSourceBundle", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class UploadSourceBundleMojo
extends AbstractMojo {
    private static Logger logger = LoggerFactory.getLogger(UploadSourceBundleMojo.class);
    @Parameter(property="sentry.cli.debug", defaultValue="false")
    private boolean debugSentryCli;
    @Parameter(property="sentry.cli.path")
    private String sentryCliExecutablePath;
    @Parameter(property="sentry.cli.properties.path")
    private String sentryPropertiesPath;
    @Parameter(property="sentry.org")
    private String org;
    @Parameter(property="sentry.project")
    private String project;
    @Parameter(property="sentry.url")
    private String url;
    @Parameter(property="sentry.authToken")
    private String authToken;
    @Parameter(property="project.build.directory")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        String bundleId = UUID.randomUUID().toString();
        File sourceBundleTargetDir = new File(this.sentryBuildDir(), "source-bundle");
        this.createDebugMetaPropertiesFile(bundleId);
        this.bundleSources(bundleId, sourceBundleTargetDir);
        this.uploadSourceBundle(sourceBundleTargetDir);
    }

    private File sentryBuildDir() {
        return new File(this.outputDirectory, "sentry");
    }

    private void bundleSources(String bundleId, File sourceBundleTargetDir) throws MojoExecutionException {
        String sourceRoot;
        if (!sourceBundleTargetDir.exists()) {
            sourceBundleTargetDir.mkdirs();
        }
        ArrayList<Object> bundleSourcesCommand = new ArrayList<Object>();
        List sourceRoots = this.mavenProject.getCompileSourceRoots();
        if (sourceRoots != null && sourceRoots.size() > 0) {
            sourceRoot = (String)sourceRoots.get(0);
            if (sourceRoots.size() > 1) {
                logger.warn("There's more than one source root, using {}", (Object)sourceRoot);
            }
            if (this.debugSentryCli) {
                bundleSourcesCommand.add("--log-level=debug");
            }
            logger.debug("Bundling sources located in {}", (Object)sourceRoot);
            if (this.url != null) {
                bundleSourcesCommand.add("--url=" + this.url);
            }
            if (this.authToken != null) {
                bundleSourcesCommand.add("--auth-token=" + this.authToken);
            }
            bundleSourcesCommand.add("debug-files");
            bundleSourcesCommand.add("bundle-jvm");
            bundleSourcesCommand.add("--output=" + sourceBundleTargetDir.getAbsolutePath());
            bundleSourcesCommand.add("--debug-id=" + bundleId);
            if (this.org != null) {
                bundleSourcesCommand.add("--org=" + this.org);
            }
            if (this.project != null) {
                bundleSourcesCommand.add("--project=" + this.project);
            }
        } else {
            throw new MojoExecutionException("Unable to find source root");
        }
        bundleSourcesCommand.add(sourceRoot);
        this.runSentryCli(String.join((CharSequence)" ", bundleSourcesCommand));
    }

    private void uploadSourceBundle(File sourceBundleTargetDir) throws MojoExecutionException {
        ArrayList<Object> command = new ArrayList<Object>();
        if (this.debugSentryCli) {
            command.add("--log-level=debug");
        }
        if (this.url != null) {
            command.add("--url=" + this.url);
        }
        if (this.authToken != null) {
            command.add("--auth-token=" + this.authToken);
        }
        command.add("debug-files");
        command.add("upload");
        command.add("--type=jvm");
        if (this.org != null) {
            command.add("--org=" + this.org);
        }
        if (this.project != null) {
            command.add("--project=" + this.project);
        }
        command.add(sourceBundleTargetDir.getAbsolutePath());
        this.runSentryCli(String.join((CharSequence)" ", command));
    }

    private void runSentryCli(String sentryCliCommand) throws MojoExecutionException {
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        String executable = isWindows ? "cmd.exe" : "/bin/sh";
        String cArg = isWindows ? "/c" : "-c";
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-antrun-plugin"), (String)MojoExecutor.version((String)"3.1.0")), (String)MojoExecutor.goal((String)"run"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"target"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"exec"), (MojoExecutor.Attributes)MojoExecutor.attributes((MojoExecutor.Attribute[])new MojoExecutor.Attribute[]{MojoExecutor.attribute((String)"executable", (String)executable)}), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"arg"), (MojoExecutor.Attributes)MojoExecutor.attributes((MojoExecutor.Attribute[])new MojoExecutor.Attribute[]{MojoExecutor.attribute((String)"value", (String)cArg)}), (MojoExecutor.Element[])new MojoExecutor.Element[0]), MojoExecutor.element((String)MojoExecutor.name((String)"arg"), (MojoExecutor.Attributes)MojoExecutor.attributes((MojoExecutor.Attribute[])new MojoExecutor.Attribute[]{MojoExecutor.attribute((String)"value", (String)(this.sentryCliExecutablePath + " " + sentryCliCommand))}), (MojoExecutor.Element[])new MojoExecutor.Element[0])})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void createDebugMetaPropertiesFile(String bundleId) throws MojoExecutionException {
        File sentryBuildDir = new File(this.sentryBuildDir(), "properties");
        if (!sentryBuildDir.exists()) {
            sentryBuildDir.mkdirs();
        }
        File debugMetaFile = new File(sentryBuildDir, "sentry-debug-meta.properties");
        Properties properties = this.createDebugMetaProperties(bundleId);
        try (FileWriter fileWriter = new FileWriter(debugMetaFile);){
            properties.store(fileWriter, "Generated by sentry-maven-plugin");
            Resource resource = new Resource();
            resource.setDirectory(sentryBuildDir.getPath());
            resource.setFiltering(false);
            this.mavenProject.addResource(resource);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + debugMetaFile, (Exception)e);
        }
    }

    private Properties createDebugMetaProperties(String bundleId) {
        Properties properties = new Properties();
        properties.setProperty("io.sentry.bundle-ids", bundleId);
        properties.setProperty("io.sentry.build-tool", "maven");
        return properties;
    }
}

