/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ArtifactResolver;
import io.sentry.ISpan;
import io.sentry.telemetry.SentryTelemetryService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="reportDependencies", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ReportDependenciesMojo
extends AbstractMojo {
    @NotNull
    public static final String EXTERNAL_MODULES_FILE = "external-modules.txt";
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(ReportDependenciesMojo.class);
    @Parameter(defaultValue="${project}", readonly=true)
    @NotNull
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    @NotNull
    private MavenSession mavenSession;
    @Parameter(property="project.build.directory")
    @NotNull
    private File outputDirectory;
    @Inject
    @NotNull
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean skipReportDependencies;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipReportDependencies) {
            logger.info("Report dependencies skipped");
            return;
        }
        @Nullable ISpan span = SentryTelemetryService.getInstance().startTask("reportDependencies");
        try {
            this.collectDependencies(this.mavenProject, this.artifactResolver.resolveArtifactsForProject(this.mavenProject, this.mavenSession));
        }
        catch (IOException | DependencyResolutionException e) {
            SentryTelemetryService.getInstance().captureError(e, "reportDependencies");
            throw new RuntimeException(e);
        }
        catch (Throwable t) {
            SentryTelemetryService.getInstance().captureError(t, "reportDependencies");
            throw t;
        }
        finally {
            SentryTelemetryService.getInstance().endTask(span);
        }
    }

    private void collectDependencies(@NotNull MavenProject mavenProject, @NotNull List<Artifact> resolvedArtifacts) throws IOException {
        @NotNull File sentryBuildDir = new File(this.outputDirectory, "external");
        if (!sentryBuildDir.exists()) {
            sentryBuildDir.mkdirs();
        }
        @NotNull File modulesFile = new File(sentryBuildDir, EXTERNAL_MODULES_FILE);
        Files.write(modulesFile.toPath(), resolvedArtifacts.stream().map(it -> it.getGroupId() + ":" + it.getArtifactId() + ":" + it.getVersion()).sorted().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        @NotNull Resource resource = new Resource();
        resource.setDirectory(sentryBuildDir.getPath());
        resource.setFiltering(false);
        mavenProject.addResource(resource);
    }
}

