/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ISpan;
import io.sentry.cli.SentryCliRunner;
import io.sentry.telemetry.SentryTelemetryService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="uploadSourceBundle", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class UploadSourceBundleMojo
extends AbstractMojo {
    private static Logger logger = LoggerFactory.getLogger(UploadSourceBundleMojo.class);
    @Parameter(property="sentry.cli.debug", defaultValue="false")
    private boolean debugSentryCli;
    @Parameter(property="sentry.cli.path")
    @Nullable
    private String sentryCliExecutablePath;
    @Parameter(property="sentry.org")
    @Nullable
    private String org;
    @Parameter(property="sentry.project")
    @Nullable
    private String project;
    @Parameter(property="sentry.url")
    @Nullable
    private String url;
    @Parameter(property="sentry.authToken")
    @Nullable
    private String authToken;
    @Parameter(property="project.build.directory")
    @NotNull
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    @NotNull
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    @NotNull
    private MavenSession mavenSession;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean skipSourceBundle;
    @Component
    @NotNull
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipSourceBundle) {
            logger.info("Upload Source Bundle skipped");
            return;
        }
        @NotNull String bundleId = UUID.randomUUID().toString();
        @NotNull File sourceBundleTargetDir = new File(this.sentryBuildDir(), "source-bundle");
        @NotNull SentryCliRunner cliRunner = new SentryCliRunner(this.debugSentryCli, this.sentryCliExecutablePath, this.mavenProject, this.mavenSession, this.pluginManager);
        this.createDebugMetaPropertiesFile(bundleId);
        this.bundleSources(cliRunner, bundleId, sourceBundleTargetDir);
        this.uploadSourceBundle(cliRunner, sourceBundleTargetDir);
    }

    @NotNull
    private File sentryBuildDir() {
        return new File(this.outputDirectory, "sentry");
    }

    private void bundleSources(@NotNull SentryCliRunner cliRunner, @NotNull String bundleId, @NotNull File sourceBundleTargetDir) throws MojoExecutionException {
        block14: {
            @Nullable ISpan span = SentryTelemetryService.getInstance().startTask("bundleSources");
            try {
                if (!sourceBundleTargetDir.exists()) {
                    sourceBundleTargetDir.mkdirs();
                }
                @NotNull ArrayList<String> bundleSourcesCommand = new ArrayList<String>();
                @NotNull List sourceRoots = this.mavenProject.getCompileSourceRoots();
                if (sourceRoots != null && sourceRoots.size() > 0) {
                    @Nullable String sourceRoot = (String)sourceRoots.get(0);
                    if (sourceRoots.size() > 1) {
                        logger.warn("There's more than one source root, using {}", (Object)sourceRoot);
                    }
                    if (this.debugSentryCli) {
                        bundleSourcesCommand.add("--log-level=debug");
                    }
                    @NotNull List<String> tracingArgs = SentryTelemetryService.getInstance().traceCli();
                    for (String tracingArg : tracingArgs) {
                        bundleSourcesCommand.add(tracingArg);
                    }
                    logger.debug("Bundling sources located in {}", (Object)sourceRoot);
                    if (this.url != null) {
                        bundleSourcesCommand.add("--url=" + this.url);
                    }
                    if (this.authToken != null) {
                        bundleSourcesCommand.add("--auth-token=" + this.authToken);
                    }
                    bundleSourcesCommand.add("debug-files");
                    bundleSourcesCommand.add("bundle-jvm");
                    bundleSourcesCommand.add("--output=" + sourceBundleTargetDir.getAbsolutePath());
                    bundleSourcesCommand.add("--debug-id=" + bundleId);
                    if (this.org != null) {
                        bundleSourcesCommand.add("--org=" + this.org);
                    }
                    if (this.project != null) {
                        bundleSourcesCommand.add("--project=" + this.project);
                    }
                    bundleSourcesCommand.add(sourceRoot);
                    cliRunner.runSentryCli(String.join((CharSequence)" ", bundleSourcesCommand), true);
                    break block14;
                }
                throw new MojoExecutionException("Unable to find source root");
            }
            catch (Throwable t) {
                SentryTelemetryService.getInstance().captureError(t, "bundleSources");
                throw t;
            }
            finally {
                SentryTelemetryService.getInstance().endTask(span);
            }
        }
    }

    private void uploadSourceBundle(@NotNull SentryCliRunner cliRunner, @NotNull File sourceBundleTargetDir) throws MojoExecutionException {
        @Nullable ISpan span = SentryTelemetryService.getInstance().startTask("uploadSourceBundle");
        try {
            @NotNull ArrayList<String> command = new ArrayList<String>();
            if (this.debugSentryCli) {
                command.add("--log-level=debug");
            }
            @NotNull List<String> tracingArgs = SentryTelemetryService.getInstance().traceCli();
            for (String tracingArg : tracingArgs) {
                command.add(tracingArg);
            }
            if (this.url != null) {
                command.add("--url=" + this.url);
            }
            if (this.authToken != null) {
                command.add("--auth-token=" + this.authToken);
            }
            command.add("debug-files");
            command.add("upload");
            command.add("--type=jvm");
            if (this.org != null) {
                command.add("--org=" + this.org);
            }
            if (this.project != null) {
                command.add("--project=" + this.project);
            }
            command.add(sourceBundleTargetDir.getAbsolutePath());
            cliRunner.runSentryCli(String.join((CharSequence)" ", command), true);
        }
        catch (Throwable t) {
            SentryTelemetryService.getInstance().captureError(t, "uploadSourceBundle");
            throw t;
        }
        finally {
            SentryTelemetryService.getInstance().endTask(span);
        }
    }

    private void createDebugMetaPropertiesFile(@NotNull String bundleId) throws MojoExecutionException {
        @Nullable ISpan span = SentryTelemetryService.getInstance().startTask("createDebugMetaPropertiesFile");
        @NotNull File sentryBuildDir = new File(this.sentryBuildDir(), "properties");
        if (!sentryBuildDir.exists()) {
            sentryBuildDir.mkdirs();
        }
        @NotNull File debugMetaFile = new File(sentryBuildDir, "sentry-debug-meta.properties");
        @NotNull Properties properties = this.createDebugMetaProperties(bundleId);
        try (@NotNull BufferedWriter fileWriter = Files.newBufferedWriter(debugMetaFile.toPath(), Charset.defaultCharset(), new OpenOption[0]);){
            properties.store(fileWriter, "Generated by sentry-maven-plugin");
            @NotNull Resource resource = new Resource();
            resource.setDirectory(sentryBuildDir.getPath());
            resource.setFiltering(false);
            this.mavenProject.addResource(resource);
        }
        catch (IOException e) {
            SentryTelemetryService.getInstance().captureError(e, "createDebugMetaPropertiesFile");
            throw new MojoExecutionException("Error creating file " + debugMetaFile, (Exception)e);
        }
        catch (Throwable t) {
            SentryTelemetryService.getInstance().captureError(t, "createDebugMetaPropertiesFile");
            throw t;
        }
        finally {
            SentryTelemetryService.getInstance().endTask(span);
        }
    }

    @NotNull
    private Properties createDebugMetaProperties(@NotNull String bundleId) {
        @NotNull Properties properties = new Properties();
        properties.setProperty("io.sentry.bundle-ids", bundleId);
        properties.setProperty("io.sentry.build-tool", "maven");
        return properties;
    }
}

