/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall.graphql;

import io.sentry.autoinstall.AbstractIntegrationInstaller;
import io.sentry.autoinstall.AutoInstallState;
import io.sentry.semver.Version;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlInstallStrategy
extends AbstractIntegrationInstaller {
    @NotNull
    private static final String GRAPHQL_GROUP = "com.graphql-java";
    @NotNull
    private static final String GRAPHQL_ID = "graphql-java";
    @NotNull
    public static final String SENTRY_GRAPHQL_ID = "sentry-graphql";

    public GraphqlInstallStrategy() {
        this(LoggerFactory.getLogger(GraphqlInstallStrategy.class));
    }

    public GraphqlInstallStrategy(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    @Nullable
    protected Artifact findThirdPartyDependency(@NotNull List<Artifact> resolvedArtifacts) {
        return resolvedArtifacts.stream().filter(dep -> dep.getGroupId().equals(GRAPHQL_GROUP) && dep.getArtifactId().equals(GRAPHQL_ID)).findFirst().orElse(null);
    }

    @Override
    protected boolean shouldInstallModule(@NotNull AutoInstallState autoInstallState) {
        return autoInstallState.isInstallGraphql();
    }

    @Override
    @NotNull
    protected Version minSupportedSentryVersion() {
        return Version.create(6, 25, 2);
    }

    @Override
    @NotNull
    protected String sentryModuleId() {
        return SENTRY_GRAPHQL_ID;
    }
}

