/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.telemetry;

import io.sentry.BaggageHeader;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpHub;
import io.sentry.NoOpTransaction;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.TransactionOptions;
import io.sentry.cli.SentryCliException;
import io.sentry.cli.SentryCliRunner;
import io.sentry.config.PluginConfig;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.User;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.Maven;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryTelemetryService {
    @Nullable
    private static volatile SentryTelemetryService instance;
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String SENTRY_SAAS_DSN = "https://dd1f82ad30a331bd7def2a0dce926c6e@o447951.ingest.sentry.io/4506031723446272";
    @NotNull
    public static final String MECHANISM_TYPE = "MavenTelemetry";
    @NotNull
    private IHub hub = NoOpHub.getInstance();
    @NotNull
    private ITransaction transaction = NoOpTransaction.getInstance();
    private boolean started = false;
    private boolean didAddChildSpans = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static SentryTelemetryService getInstance() {
        if (instance != null) return instance;
        Class<SentryTelemetryService> clazz = SentryTelemetryService.class;
        synchronized (SentryTelemetryService.class) {
            if (instance != null) return instance;
            instance = new SentryTelemetryService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SentryTelemetryService() {
    }

    public void start(@NotNull PluginConfig pluginConfig, @NotNull MavenProject mavenProject, @NotNull MavenSession mavenSession, @NotNull BuildPluginManager pluginManager) {
        try {
            if (this.started) {
                return;
            }
            this.started = true;
            if (pluginConfig.isSkipTelemetry()) {
                logger.info("Sentry telemetry has been disabled.");
            } else {
                @NotNull SentryCliRunner cliRunner = new SentryCliRunner(pluginConfig.isDebugSentryCli(), pluginConfig.getSentryCliExecutablePath(), mavenProject, mavenSession, pluginManager);
                @Nullable InfoOutput infoOutput = this.determineSentryCliInfo(cliRunner, pluginConfig);
                if (infoOutput != null && infoOutput.isSaas) {
                    logger.info("Sentry telemetry has been disabled because this build is running against a self hosted instance.");
                    return;
                }
                @Nullable String sentryCliVersion = this.determineVersionFromSentryCli(cliRunner);
                logger.info("Sentry telemetry is enabled. To disable set `<skipTelemetry>` to `true`.");
                Sentry.init(options -> {
                    options.setDsn(SENTRY_SAAS_DSN);
                    options.setDebug(pluginConfig.isDebug());
                    options.setEnablePrettySerializationOutput(false);
                    options.setEnvironment("JVM");
                    options.setSendModules(false);
                    options.setTracesSampleRate(Double.valueOf(1.0));
                    options.setRelease(SentryTelemetryService.class.getPackage().getImplementationVersion());
                    options.setTag("BUILD_SYSTEM", "maven");
                    options.setTag("BUILD_TYPE", "JVM");
                    options.setTag("MAVEN_VERSION", Maven.class.getPackage().getImplementationVersion());
                    if (sentryCliVersion != null) {
                        options.setTag("SENTRY_CLI_VERSION", sentryCliVersion);
                    }
                    options.setTag("SENTRY_autoInstallation_enabled", String.valueOf(!pluginConfig.isSkipAutoInstall()));
                    options.setTag("SENTRY_includeDependenciesReport", String.valueOf(!pluginConfig.isSkipReportDependencies()));
                    options.setTag("SENTRY_includeSourceContext", String.valueOf(!pluginConfig.isSkipSourceBundle()));
                });
                this.hub = Sentry.getCurrentHub();
                this.startRun("maven build");
                this.hub.configureScope(scope -> {
                    String org;
                    String defaultOrg;
                    @NotNull User user = new User();
                    if (infoOutput != null && (defaultOrg = infoOutput.org) != null) {
                        user.setId(defaultOrg);
                    }
                    if ((org = pluginConfig.getOrg()) != null) {
                        user.setId(org);
                    }
                    scope.setUser(user);
                });
            }
        }
        catch (Throwable t) {
            logger.error("Sentry failed to initialize.", t);
        }
    }

    @Nullable
    private InfoOutput determineSentryCliInfo(@NotNull SentryCliRunner cliRunner, @NotNull PluginConfig pluginConfig) {
        String authToken;
        ArrayList<String> command = new ArrayList<String>();
        @Nullable String url = pluginConfig.getUrl();
        if (url != null) {
            command.add("--url");
            command.add(url);
        }
        if ((authToken = pluginConfig.getAuthToken()) != null) {
            command.add("--auth-token");
            command.add(authToken);
        }
        command.add("info");
        try {
            @Nullable String infoOutput = cliRunner.runSentryCli(String.join((CharSequence)" ", command), false);
            if (infoOutput != null) {
                InfoOutput info = new InfoOutput();
                info.isSaas = infoOutput.matches("(?m)Sentry Server: .*sentry.io$");
                @NotNull Pattern orgRegex = Pattern.compile("(?m)Default Organization: (.*)$", 8);
                @NotNull Matcher matcher = orgRegex.matcher(infoOutput);
                if (matcher.find()) {
                    info.org = matcher.group(1);
                }
                return info;
            }
            return null;
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private String determineVersionFromSentryCli(@NotNull SentryCliRunner cliRunner) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("--log-level=error");
        command.add("--version");
        try {
            Pattern versionRegex;
            Matcher matcher;
            @Nullable String versionOutput = cliRunner.runSentryCli(String.join((CharSequence)" ", command), false);
            if (versionOutput != null && (matcher = (versionRegex = Pattern.compile("sentry-cli (.*)$", 8)).matcher(versionOutput)).find()) {
                return matcher.group(1);
            }
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void startRun(@NotNull String transactionName) {
        this.hub.startSession();
        @NotNull TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setBindToScope(true);
        this.transaction = this.hub.startTransaction(transactionName, "build", transactionOptions);
    }

    private void endRun() {
        if (this.didAddChildSpans) {
            this.hub.endSession();
            this.transaction.finish();
        }
    }

    @Nullable
    public ISpan startTask(@NotNull String operation) {
        this.didAddChildSpans = true;
        this.hub.setTag("step", operation);
        @Nullable ISpan span = this.hub.getSpan();
        if (span != null) {
            return span.startChild(operation);
        }
        return null;
    }

    public void endTask(@Nullable ISpan span) {
        if (span != null) {
            span.finish();
        }
    }

    public void captureError(@NotNull Throwable exception, @NotNull String operation) {
        @NotNull String message = exception instanceof SentryCliException ? operation + " failed with SentryCliException and reason " + ((SentryCliException)exception).getReason().name() : operation + " failed with " + exception.getClass();
        @NotNull Mechanism mechanism = new Mechanism();
        mechanism.setType(MECHANISM_TYPE);
        mechanism.setHandled(Boolean.valueOf(false));
        @NotNull SentryMinimalException throwable = new SentryMinimalException(message);
        @NotNull ExceptionMechanismException mechanismException = new ExceptionMechanismException(mechanism, (Throwable)throwable, Thread.currentThread());
        @NotNull SentryEvent event = new SentryEvent((Throwable)mechanismException);
        event.setLevel(SentryLevel.FATAL);
        this.hub.captureEvent(event);
    }

    public void markFailed() {
        this.transaction.setStatus(SpanStatus.UNKNOWN_ERROR);
    }

    public void close() {
        if (!this.transaction.isFinished()) {
            this.endRun();
        }
        Sentry.close();
    }

    @NotNull
    public List<String> traceCli() {
        BaggageHeader baggage;
        @NotNull ArrayList<String> args = new ArrayList<String>();
        @Nullable SentryTraceHeader traceparent = this.hub.getTraceparent();
        if (traceparent != null) {
            args.add("--header");
            args.add(traceparent.getName() + ":" + traceparent.getValue());
        }
        if ((baggage = this.hub.getBaggage()) != null) {
            args.add("--header");
            args.add(baggage.getName() + ":" + baggage.getValue());
        }
        return args;
    }

    public void addTag(@NotNull String key, @NotNull String value) {
        this.hub.setTag(key, value);
    }

    static {
        logger = LoggerFactory.getLogger(SentryTelemetryService.class);
    }

    private static class InfoOutput {
        boolean isSaas;
        @Nullable
        String org;

        private InfoOutput() {
        }
    }

    public static class SentryMinimalException
    extends RuntimeException {
        public SentryMinimalException(@NotNull String message) {
            super(message);
        }
    }
}

