/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall.graphql;

import io.sentry.autoinstall.AbstractIntegrationInstaller;
import io.sentry.autoinstall.AutoInstallState;
import io.sentry.semver.Version;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graphql22InstallStrategy
extends AbstractIntegrationInstaller {
    @NotNull
    private static final String GRAPHQL_GROUP = "com.graphql-java";
    @NotNull
    private static final String GRAPHQL_ID = "graphql-java";
    @NotNull
    public static final String SENTRY_GRAPHQL_22_ID = "sentry-graphql-22";

    public Graphql22InstallStrategy() {
        this(LoggerFactory.getLogger(Graphql22InstallStrategy.class));
    }

    public Graphql22InstallStrategy(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    @Nullable
    protected Artifact findThirdPartyDependency(@NotNull List<Artifact> resolvedArtifacts) {
        return resolvedArtifacts.stream().filter(dep -> dep.getGroupId().equals(GRAPHQL_GROUP) && dep.getArtifactId().equals(GRAPHQL_ID)).findFirst().orElse(null);
    }

    @Override
    protected boolean shouldInstallModule(@NotNull AutoInstallState autoInstallState) {
        return autoInstallState.isInstallGraphql();
    }

    @Override
    @Nullable
    protected Version minSupportedThirdPartyVersion() {
        return Version.create(22, 0, 0);
    }

    @Override
    @NotNull
    protected Version minSupportedSentryVersion() {
        return Version.create(8, 0, 0);
    }

    @Override
    @NotNull
    protected String sentryModuleId() {
        return SENTRY_GRAPHQL_22_ID;
    }
}

