/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ArtifactResolver;
import io.sentry.ISpan;
import io.sentry.autoinstall.AbstractIntegrationInstaller;
import io.sentry.autoinstall.AutoInstallState;
import io.sentry.autoinstall.SentryInstaller;
import io.sentry.autoinstall.graphql.Graphql22InstallStrategy;
import io.sentry.autoinstall.graphql.GraphqlInstallStrategy;
import io.sentry.autoinstall.jdbc.JdbcInstallStrategy;
import io.sentry.autoinstall.log4j2.Log4j2InstallStrategy;
import io.sentry.autoinstall.logback.LogbackInstallStrategy;
import io.sentry.autoinstall.quartz.QuartzInstallStrategy;
import io.sentry.autoinstall.spring.Spring5InstallStrategy;
import io.sentry.autoinstall.spring.Spring6InstallStrategy;
import io.sentry.autoinstall.spring.SpringBoot2InstallStrategy;
import io.sentry.autoinstall.spring.SpringBoot3InstallStrategy;
import io.sentry.config.ConfigParser;
import io.sentry.config.PluginConfig;
import io.sentry.telemetry.SentryTelemetryService;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="sentry-installer")
@Singleton
public class SentryInstallerLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    @NotNull
    private static final List<Class<? extends AbstractIntegrationInstaller>> installers = Stream.of(Spring5InstallStrategy.class, Spring6InstallStrategy.class, SpringBoot2InstallStrategy.class, SpringBoot3InstallStrategy.class, Log4j2InstallStrategy.class, LogbackInstallStrategy.class, GraphqlInstallStrategy.class, Graphql22InstallStrategy.class, JdbcInstallStrategy.class, QuartzInstallStrategy.class).collect(Collectors.toList());
    @Inject
    @NotNull
    ArtifactResolver resolver;
    @Inject
    @NotNull
    private BuildPluginManager pluginManager;
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(SentryInstallerLifecycleParticipant.class);

    public void afterProjectsRead(@NotNull MavenSession session) throws MavenExecutionException {
        for (MavenProject project : session.getProjects()) {
            List<Artifact> resolvedArtifacts;
            @NotNull PluginConfig pluginConfig = new ConfigParser().parseConfig(project);
            SentryTelemetryService.getInstance().start(pluginConfig, project, session, this.pluginManager);
            if (pluginConfig.isSkipAutoInstall()) {
                logger.info("Auto Install disabled for project " + project.getId() + " , not installing dependencies");
                continue;
            }
            @Nullable ISpan span = SentryTelemetryService.getInstance().startTask("auto-install");
            try {
                resolvedArtifacts = this.resolver.resolveArtifactsForProject(project, session);
            }
            catch (DependencyResolutionException e) {
                logger.error("Unable to resolve all dependencies", (Throwable)e);
                SentryTelemetryService.getInstance().endTask(span);
                continue;
            }
            try {
                @NotNull Model currModel = project.getModel();
                @NotNull List dependencyList = currModel.getDependencies();
                @Nullable String sentryVersion = new SentryInstaller().install(dependencyList, resolvedArtifacts);
                if (sentryVersion == null) {
                    logger.error("No Sentry SDK Version found, cannot auto-install sentry integrations for project + " + project.getId());
                    continue;
                }
                SentryTelemetryService.getInstance().addTag("SDK_VERSION", sentryVersion);
                @NotNull AutoInstallState autoInstallState = new AutoInstallState(sentryVersion);
                autoInstallState.setInstallSpring(this.shouldInstallSpring(resolvedArtifacts));
                autoInstallState.setInstallLogback(!SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-logback"));
                autoInstallState.setInstallLog4j2(!SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-log4j2"));
                autoInstallState.setInstallGraphql(this.shouldInstallGraphQL(resolvedArtifacts));
                autoInstallState.setInstallJdbc(!SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-jdbc"));
                autoInstallState.setInstallQuartz(!SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-quartz"));
                for (Class<? extends AbstractIntegrationInstaller> installerClass : installers) {
                    try {
                        @NotNull AbstractIntegrationInstaller installer = installerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        installer.install(dependencyList, resolvedArtifacts, autoInstallState);
                    }
                    catch (Throwable e) {
                        logger.error("Unable to instantiate installer class: " + installerClass.getName(), e);
                    }
                }
            }
            catch (Throwable t) {
                SentryTelemetryService.getInstance().captureError(t, "auto-install");
                throw t;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                SentryTelemetryService.getInstance().endTask(span);
            }
        }
        super.afterProjectsRead(session);
    }

    private boolean shouldInstallSpring(@NotNull List<Artifact> resolvedArtifacts) {
        return !SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-spring") && !SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-spring-jakarta") && !SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-spring-boot") && !SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-spring-boot-jakarta");
    }

    private boolean shouldInstallGraphQL(@NotNull List<Artifact> resolvedArtifacts) {
        return !SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-graphql") && !SentryInstallerLifecycleParticipant.isModuleAvailable(resolvedArtifacts, "sentry-graphql-22");
    }

    public static boolean isModuleAvailable(@NotNull List<Artifact> resolvedArtifacts, @NotNull String artifactId) {
        return resolvedArtifacts.stream().anyMatch(dep -> dep.getGroupId().equals("io.sentry") && dep.getArtifactId().equals(artifactId));
    }

    public void afterSessionEnd(@Nullable MavenSession session) throws MavenExecutionException {
        MavenExecutionResult result;
        if (session != null && (result = session.getResult()) != null && result.hasExceptions()) {
            SentryTelemetryService.getInstance().markFailed();
        }
        SentryTelemetryService.getInstance().close();
        super.afterSessionEnd(session);
    }
}

