/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall;

import io.sentry.autoinstall.AutoInstallState;
import io.sentry.semver.Version;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AbstractIntegrationInstaller {
    @NotNull
    protected Logger logger;

    @Nullable
    protected Version minSupportedThirdPartyVersion() {
        return null;
    }

    @Nullable
    protected Version maxSupportedThirdPartyVersion() {
        return null;
    }

    @NotNull
    protected Version minSupportedSentryVersion() {
        return Version.create(0, 0, 0);
    }

    @Nullable
    protected abstract Artifact findThirdPartyDependency(@NotNull List<Artifact> var1);

    protected abstract boolean shouldInstallModule(@NotNull AutoInstallState var1);

    @NotNull
    protected abstract String sentryModuleId();

    protected AbstractIntegrationInstaller(@NotNull Logger logger) {
        this.logger = logger;
    }

    public void install(@NotNull List<Dependency> dependencyList, @NotNull List<Artifact> resolvedArtifacts, @NotNull AutoInstallState autoInstallState) {
        if (!this.shouldInstallModule(autoInstallState)) {
            this.logger.info(this.sentryModuleId() + " won't be installed because it was already installed directly");
            return;
        }
        @NotNull String sentryVersion = autoInstallState.getSentryVersion();
        @Nullable Artifact thirdPartyDependency = this.findThirdPartyDependency(resolvedArtifacts);
        if (thirdPartyDependency == null) {
            this.logger.info(this.sentryModuleId() + " won't be installed because its third party dependency could not be found ");
            return;
        }
        if (this.minSupportedThirdPartyVersion() != null && this.parseVersion(thirdPartyDependency.getVersion()).isLowerThan(this.minSupportedThirdPartyVersion())) {
            this.logger.info(this.sentryModuleId() + " won't be installed because the current version is lower than the minimum supported version " + this.minSupportedThirdPartyVersion());
            return;
        }
        if (this.maxSupportedThirdPartyVersion() != null && this.parseVersion(thirdPartyDependency.getVersion()).isGreaterThan(this.maxSupportedThirdPartyVersion())) {
            this.logger.info(this.sentryModuleId() + " won't be installed because the current version is higher than the maximum supported version " + this.maxSupportedThirdPartyVersion());
            return;
        }
        if (this.minSupportedSentryVersion().getMajor() > 0) {
            try {
                @NotNull Version sentrySemVersion = Version.parseVersion(sentryVersion);
                if (sentrySemVersion.isLowerThan(this.minSupportedSentryVersion())) {
                    this.logger.warn(this.sentryModuleId() + " won't be installed because the current version is lower than the minimum supported sentry version " + sentryVersion);
                    return;
                }
            }
            catch (IllegalArgumentException ex) {
                this.logger.warn(this.sentryModuleId() + " won't be installed because the provided sentry version($autoInstallState.sentryVersion) could not be processed as a semantic version.");
                return;
            }
        }
        this.logger.info("Installing " + this.sentryModuleId());
        @NotNull Dependency newDep = new Dependency();
        newDep.setGroupId("io.sentry");
        newDep.setArtifactId(this.sentryModuleId());
        newDep.setVersion(sentryVersion);
        dependencyList.add(newDep);
        this.logger.info(this.sentryModuleId() + " was successfully installed with version: " + sentryVersion);
    }

    @NotNull
    private Version parseVersion(@NotNull String version) {
        @NotNull String suffix = ".RELEASE";
        return Version.parseVersion(version.endsWith(".RELEASE") ? version.substring(0, version.length() - ".RELEASE".length()) : version);
    }
}

