/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cli;

import io.sentry.SentryCliProvider;
import io.sentry.cli.CliFailureReason;
import io.sentry.cli.SentryCliException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Locale;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class SentryCliRunner {
    private static Logger logger = LoggerFactory.getLogger(SentryCliRunner.class);
    private final boolean debugSentryCli;
    @Nullable
    private final String sentryCliExecutablePath;
    @NotNull
    private final MavenProject mavenProject;
    @NotNull
    private final MavenSession mavenSession;
    @NotNull
    private final BuildPluginManager pluginManager;

    public SentryCliRunner(boolean debugSentryCli, @Nullable String sentryCliExecutablePath, @NotNull MavenProject mavenProject, @NotNull MavenSession mavenSession, @NotNull BuildPluginManager pluginManager) {
        this.debugSentryCli = debugSentryCli;
        this.sentryCliExecutablePath = sentryCliExecutablePath;
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.pluginManager = pluginManager;
    }

    @Nullable
    public String runSentryCli(@NotNull String sentryCliCommand, boolean failOnError) throws MojoExecutionException {
        boolean isWindows = SentryCliRunner.isWindows();
        @NotNull String executable = isWindows ? "cmd.exe" : "/bin/sh";
        @NotNull String cArg = isWindows ? "/c" : "-c";
        File logFile = null;
        try {
            logFile = File.createTempFile("maven", "cli");
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-antrun-plugin"), (String)MojoExecutor.version((String)"3.1.0")), (String)MojoExecutor.goal((String)"run"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"target"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"exec"), (MojoExecutor.Attributes)MojoExecutor.attributes((MojoExecutor.Attribute[])new MojoExecutor.Attribute[]{MojoExecutor.attribute((String)"executable", (String)executable), MojoExecutor.attribute((String)"failOnError", (String)String.valueOf(failOnError)), MojoExecutor.attribute((String)"output", (String)this.escape(logFile.getAbsolutePath()))}), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"arg"), (MojoExecutor.Attributes)MojoExecutor.attributes((MojoExecutor.Attribute[])new MojoExecutor.Attribute[]{MojoExecutor.attribute((String)"value", (String)cArg)}), (MojoExecutor.Element[])new MojoExecutor.Element[0]), MojoExecutor.element((String)MojoExecutor.name((String)"arg"), (MojoExecutor.Attributes)MojoExecutor.attributes((MojoExecutor.Attribute[])new MojoExecutor.Attribute[]{MojoExecutor.attribute((String)"value", (String)this.wrapForWindows(this.escape(SentryCliProvider.getCliPath(this.mavenProject, this.sentryCliExecutablePath)) + " " + sentryCliCommand))}), (MojoExecutor.Element[])new MojoExecutor.Element[0])})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
            return this.collectAndMaybePrintOutput(logFile, this.debugSentryCli);
        }
        catch (MojoExecutionException e) {
            String output;
            logger.error("Error while attempting to run Sentry CLI: ", (Throwable)e);
            if (logFile != null && (output = this.collectAndMaybePrintOutput(logFile, true)) != null) {
                @NotNull CliFailureReason failureReason = this.failureReasonFromCliOutput(output);
                throw new SentryCliException(failureReason);
            }
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isWindows() {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("windows");
        return isWindows;
    }

    @Nullable
    private String wrapForWindows(@Nullable String toWrap) {
        if (toWrap != null && SentryCliRunner.isWindows()) {
            return "\"" + toWrap + "\"";
        }
        return toWrap;
    }

    @Nullable
    public String escape(@Nullable String escapePath) {
        if (escapePath == null) {
            return null;
        }
        if (SentryCliRunner.isWindows()) {
            if (escapePath.contains(" ")) {
                return "\"" + escapePath + "\"";
            }
            return escapePath;
        }
        return escapePath.replaceAll(" ", "\\\\ ");
    }

    @Nullable
    private String collectAndMaybePrintOutput(@NotNull File logFile, boolean shouldPrint) {
        try {
            @NotNull String output = new String(Files.readAllBytes(logFile.toPath()));
            if (shouldPrint) {
                logger.info(output);
            }
            return output;
        }
        catch (IOException e) {
            logger.error("Failed to read sentry-cli output file.", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private CliFailureReason failureReasonFromCliOutput(@NotNull String outputString) {
        logger.error(outputString);
        if (outputString.contains("error: resource not found")) {
            return CliFailureReason.OUTDATED;
        }
        if (outputString.contains("error: An organization slug is required")) {
            return CliFailureReason.ORG_SLUG;
        }
        if (outputString.contains("error: A project slug is required")) {
            return CliFailureReason.PROJECT_SLUG;
        }
        if (outputString.contains("error: Failed to parse org auth token")) {
            return CliFailureReason.INVALID_ORG_AUTH_TOKEN;
        }
        if (outputString.contains("error: API request failed") && outputString.contains("Invalid token (http status:")) {
            return CliFailureReason.INVALID_TOKEN;
        }
        return CliFailureReason.UNKNOWN;
    }
}

