/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.sentry.BaggageHeader;
import io.sentry.Hint;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Instrumenter;
import io.sentry.MeasurementUnit;
import io.sentry.SentryDate;
import io.sentry.SentryTraceHeader;
import io.sentry.Span;
import io.sentry.SpanContext;
import io.sentry.SpanOptions;
import io.sentry.SpanStatus;
import io.sentry.TraceContext;
import io.sentry.TracesSamplingDecision;
import io.sentry.opentelemetry.IOtelSpanWrapper;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class OtelTransactionSpanForwarder
implements ITransaction {
    @NotNull
    private final IOtelSpanWrapper rootSpan;

    public OtelTransactionSpanForwarder(@NotNull IOtelSpanWrapper rootSpan) {
        this.rootSpan = Objects.requireNonNull(rootSpan, "root span is required");
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.rootSpan.startChild(operation);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @NotNull SpanOptions spanOptions) {
        return this.rootSpan.startChild(operation, description, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull SpanContext spanContext, @NotNull SpanOptions spanOptions) {
        return this.rootSpan.startChild(spanContext, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter) {
        return this.rootSpan.startChild(operation, description, timestamp, instrumenter);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp, @NotNull Instrumenter instrumenter, @NotNull SpanOptions spanOptions) {
        return this.rootSpan.startChild(operation, description, timestamp, instrumenter, spanOptions);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        return this.rootSpan.startChild(operation, description);
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return this.rootSpan.toSentryTrace();
    }

    @Override
    @Nullable
    public TraceContext traceContext() {
        return this.rootSpan.traceContext();
    }

    @Override
    @Nullable
    public BaggageHeader toBaggageHeader(@Nullable List<String> thirdPartyBaggageHeaders) {
        return this.rootSpan.toBaggageHeader(thirdPartyBaggageHeaders);
    }

    @Override
    public void finish() {
        this.rootSpan.finish();
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        this.rootSpan.finish(status);
    }

    @Override
    public void finish(@Nullable SpanStatus status, @Nullable SentryDate timestamp) {
        this.rootSpan.finish(status, timestamp);
    }

    @Override
    public void setOperation(@NotNull String operation) {
        this.rootSpan.startChild(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.rootSpan.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        this.rootSpan.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.rootSpan.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        this.rootSpan.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.rootSpan.getStatus();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        this.rootSpan.setThrowable(throwable);
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.rootSpan.getThrowable();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.rootSpan.getSpanContext();
    }

    @Override
    public void setTag(@Nullable String key, @Nullable String value) {
        this.rootSpan.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@Nullable String key) {
        return this.rootSpan.getTag(key);
    }

    @Override
    public boolean isFinished() {
        return this.rootSpan.isFinished();
    }

    @Override
    public void setData(@Nullable String key, @Nullable Object value) {
        this.rootSpan.setData(key, value);
    }

    @Override
    @Nullable
    public Object getData(@Nullable String key) {
        return this.rootSpan.getData(key);
    }

    @Override
    public void setMeasurement(@NotNull String name, @NotNull Number value) {
        this.rootSpan.setMeasurement(name, value);
    }

    @Override
    public void setMeasurement(@NotNull String name, @NotNull Number value, @NotNull MeasurementUnit unit) {
        this.rootSpan.setMeasurement(name, value, unit);
    }

    @Override
    public boolean updateEndDate(@NotNull SentryDate date) {
        return this.rootSpan.updateEndDate(date);
    }

    @Override
    @NotNull
    public SentryDate getStartDate() {
        return this.rootSpan.getStartDate();
    }

    @Override
    @Nullable
    public SentryDate getFinishDate() {
        return this.rootSpan.getFinishDate();
    }

    @Override
    public boolean isNoOp() {
        return this.rootSpan.isNoOp();
    }

    @Override
    @NotNull
    public TransactionNameSource getTransactionNameSource() {
        @Nullable TransactionNameSource nameSource = this.rootSpan.getTransactionNameSource();
        if (nameSource == null) {
            return TransactionNameSource.CUSTOM;
        }
        return nameSource;
    }

    @Override
    @NotNull
    public List<Span> getSpans() {
        return new ArrayList<Span>();
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable SentryDate timestamp) {
        return this.rootSpan.startChild(operation, description, timestamp, Instrumenter.SENTRY);
    }

    @Override
    @Nullable
    public Boolean isSampled() {
        return this.rootSpan.isSampled();
    }

    @Override
    @Nullable
    public Boolean isProfileSampled() {
        return this.rootSpan.isProfileSampled();
    }

    @Override
    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        return this.rootSpan.getSamplingDecision();
    }

    @Override
    @Nullable
    public ISpan getLatestActiveSpan() {
        return this.rootSpan;
    }

    @Override
    @NotNull
    public SentryId getEventId() {
        return new SentryId();
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public ISentryLifecycleToken makeCurrent() {
        return this.rootSpan.makeCurrent();
    }

    @Override
    public void scheduleFinish() {
    }

    @Override
    public void forceFinish(@NotNull SpanStatus status, boolean dropIfNoChildren, @Nullable Hint hint) {
        this.rootSpan.finish(status);
    }

    @Override
    public void finish(@Nullable SpanStatus status, @Nullable SentryDate timestamp, boolean dropIfNoChildren, @Nullable Hint hint) {
        this.rootSpan.finish(status, timestamp);
    }

    @Override
    public void setContext(@Nullable String key, @Nullable Object context) {
        this.rootSpan.setContext(key, context);
    }

    @Override
    @NotNull
    public Contexts getContexts() {
        return this.rootSpan.getContexts();
    }

    @Override
    public void setName(@NotNull String name) {
        this.rootSpan.setTransactionName(name);
    }

    @Override
    public void setName(@NotNull String name, @NotNull TransactionNameSource nameSource) {
        this.rootSpan.setTransactionName(name, nameSource);
    }

    @Override
    @NotNull
    public String getName() {
        @Nullable String name = this.rootSpan.getTransactionName();
        if (name == null) {
            return "<unlabeled transaction>";
        }
        return name;
    }
}

