/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextStorage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextStorageProvider;
import io.sentry.opentelemetry.SentryContextStorage;
import io.sentry.opentelemetry.SentryOtelThreadLocalStorage;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;

public final class SentryContextStorageProvider
implements ContextStorageProvider {
    @Override
    public ContextStorage get() {
        return new SentryContextStorage(this.findStorageToWrap());
    }

    @NotNull
    private ContextStorage findStorageToWrap() {
        try {
            ServiceLoader<ContextStorageProvider> serviceLoader = ServiceLoader.load(ContextStorageProvider.class);
            for (ContextStorageProvider contextStorageProvider : serviceLoader) {
                if (contextStorageProvider instanceof SentryContextStorageProvider) continue;
                return contextStorageProvider.get();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SentryOtelThreadLocalStorage();
    }
}

