/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextStorage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import java.util.logging.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public final class SentryOtelThreadLocalStorage
implements ContextStorage {
    private static final PatchLogger logger = PatchLogger.getLogger(SentryOtelThreadLocalStorage.class.getName());
    private static final ThreadLocal<Context> THREAD_LOCAL_STORAGE = new ThreadLocal();

    @Override
    public Scope attach(Context toAttach) {
        if (toAttach == null) {
            return NoopScope.INSTANCE;
        }
        Context beforeAttach = this.current();
        if (toAttach == beforeAttach) {
            return NoopScope.INSTANCE;
        }
        THREAD_LOCAL_STORAGE.set(toAttach);
        return new SentryScopeImpl(beforeAttach);
    }

    @Override
    @Nullable
    public Context current() {
        return THREAD_LOCAL_STORAGE.get();
    }

    static enum NoopScope implements Scope
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }

    private static class SentryScopeImpl
    implements Scope {
        @Nullable
        private final Context beforeAttach;
        private boolean closed;

        private SentryScopeImpl(@Nullable Context beforeAttach) {
            this.beforeAttach = beforeAttach;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                THREAD_LOCAL_STORAGE.set(this.beforeAttach);
            } else {
                logger.log(Level.FINE, " Trying to close scope which does not represent current context. Ignoring the call.");
            }
        }
    }
}

