/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.sentry.ISentryLifecycleToken;
import io.sentry.opentelemetry.IOtelSpanWrapper;
import io.sentry.util.AutoClosableReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryWeakSpanStorage {
    @Nullable
    private static volatile SentryWeakSpanStorage INSTANCE;
    @NotNull
    private static final AutoClosableReentrantLock staticLock;
    @NotNull
    private final WeakConcurrentMap<SpanContext, IOtelSpanWrapper> sentrySpans = new WeakConcurrentMap(true);

    @NotNull
    public static SentryWeakSpanStorage getInstance() {
        if (INSTANCE == null) {
            try (@NotNull ISentryLifecycleToken ignored = staticLock.acquire();){
                if (INSTANCE == null) {
                    INSTANCE = new SentryWeakSpanStorage();
                }
            }
        }
        return INSTANCE;
    }

    private SentryWeakSpanStorage() {
    }

    @Nullable
    public IOtelSpanWrapper getSentrySpan(@NotNull SpanContext spanContext) {
        return (IOtelSpanWrapper)this.sentrySpans.get((Object)spanContext);
    }

    public void storeSentrySpan(@NotNull SpanContext otelSpan, @NotNull IOtelSpanWrapper sentrySpan) {
        this.sentrySpans.put((Object)otelSpan, (Object)sentrySpan);
    }

    @TestOnly
    public void clear() {
        this.sentrySpans.clear();
    }

    static {
        staticLock = new AutoClosableReentrantLock();
    }
}

