/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class FilterString {
    @NotNull
    private final String filterString;
    @NotNull
    private final Pattern pattern;

    public FilterString(@NotNull String filterString) {
        this.filterString = filterString;
        this.pattern = Pattern.compile(filterString);
    }

    @NotNull
    public String getFilterString() {
        return this.filterString;
    }

    public boolean matches(String input) {
        return this.pattern.matcher(input).matches();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterString that = (FilterString)o;
        return Objects.equals(this.filterString, that.filterString);
    }

    public int hashCode() {
        return Objects.hash(this.filterString);
    }
}

