/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ISentryLifecycleToken;
import io.sentry.protocol.SentryPackage;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SentryIntegrationPackageStorage {
    @Nullable
    private static volatile SentryIntegrationPackageStorage INSTANCE;
    @NotNull
    private static final AutoClosableReentrantLock staticLock;
    private final Set<String> integrations = new CopyOnWriteArraySet<String>();
    private final Set<SentryPackage> packages = new CopyOnWriteArraySet<SentryPackage>();

    @NotNull
    public static SentryIntegrationPackageStorage getInstance() {
        if (INSTANCE == null) {
            try (@NotNull ISentryLifecycleToken ignored = staticLock.acquire();){
                if (INSTANCE == null) {
                    INSTANCE = new SentryIntegrationPackageStorage();
                }
            }
        }
        return INSTANCE;
    }

    private SentryIntegrationPackageStorage() {
    }

    public void addIntegration(@NotNull String integration) {
        Objects.requireNonNull(integration, "integration is required.");
        this.integrations.add(integration);
    }

    @NotNull
    public Set<String> getIntegrations() {
        return this.integrations;
    }

    public void addPackage(@NotNull String name, @NotNull String version) {
        Objects.requireNonNull(name, "name is required.");
        Objects.requireNonNull(version, "version is required.");
        SentryPackage newPackage = new SentryPackage(name, version);
        this.packages.add(newPackage);
    }

    @NotNull
    public Set<SentryPackage> getPackages() {
        return this.packages;
    }

    @TestOnly
    public void clearStorage() {
        this.integrations.clear();
        this.packages.clear();
    }

    static {
        staticLock = new AutoClosableReentrantLock();
    }
}

