/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.sentry.Baggage;
import io.sentry.IScopes;
import io.sentry.ISpan;
import io.sentry.ISpanFactory;
import io.sentry.ITransaction;
import io.sentry.NoOpSpan;
import io.sentry.NoOpTransaction;
import io.sentry.SentryDate;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanOptions;
import io.sentry.TracesSamplingDecision;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.opentelemetry.IOtelSpanWrapper;
import io.sentry.opentelemetry.InternalSemanticAttributes;
import io.sentry.opentelemetry.OtelStrongRefSpanWrapper;
import io.sentry.opentelemetry.OtelTransactionSpanForwarder;
import io.sentry.opentelemetry.SentryWeakSpanStorage;
import io.sentry.protocol.SentryId;
import io.sentry.util.SpanUtils;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class OtelSpanFactory
implements ISpanFactory {
    @NotNull
    private final SentryWeakSpanStorage storage = SentryWeakSpanStorage.getInstance();
    @Nullable
    private final OpenTelemetry openTelemetry;

    public OtelSpanFactory(@Nullable OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public OtelSpanFactory() {
        this(null);
    }

    @Override
    @NotNull
    public ITransaction createTransaction(@NotNull TransactionContext context, @NotNull IScopes scopes, @NotNull TransactionOptions transactionOptions, @Nullable TransactionPerformanceCollector transactionPerformanceCollector) {
        @Nullable IOtelSpanWrapper span = this.createSpanInternal(scopes, transactionOptions, null, context.getSamplingDecision(), context);
        if (span == null) {
            return NoOpTransaction.getInstance();
        }
        return new OtelTransactionSpanForwarder(span);
    }

    @Override
    @NotNull
    public ISpan createSpan(@NotNull IScopes scopes, @NotNull SpanOptions spanOptions, @NotNull SpanContext spanContext, @Nullable ISpan parentSpan) {
        if (SpanUtils.isIgnored(scopes.getOptions().getIgnoredSpanOrigins(), spanOptions.getOrigin())) {
            return NoOpSpan.getInstance();
        }
        @Nullable TracesSamplingDecision samplingDecision = parentSpan == null ? null : parentSpan.getSamplingDecision();
        @Nullable IOtelSpanWrapper span = this.createSpanInternal(scopes, spanOptions, parentSpan, samplingDecision, spanContext);
        if (span == null) {
            return NoOpSpan.getInstance();
        }
        return span;
    }

    @Nullable
    private IOtelSpanWrapper createSpanInternal(@NotNull IScopes scopes, @NotNull SpanOptions spanOptions, @Nullable ISpan parentSpan, @Nullable TracesSamplingDecision samplingDecision, @NotNull SpanContext spanContext) {
        Span otelSpan;
        IOtelSpanWrapper sentrySpan;
        SentryDate startTimestampFromOptions;
        @NotNull String name = spanContext.getOperation();
        @NotNull SpanBuilder spanBuilder = this.getTracer().spanBuilder(name);
        if (parentSpan == null) {
            Span wrappedSpan;
            io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext otelSpanContext;
            @NotNull SentryId traceId = spanContext.getTraceId();
            @Nullable SpanId parentSpanId = spanContext.getParentSpanId();
            if (parentSpanId == null) {
                otelSpanContext = io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext.create(traceId.toString(), io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanId.getInvalid(), TraceFlags.getSampled(), TraceState.getDefault());
                wrappedSpan = Span.wrap(otelSpanContext);
                spanBuilder.setParent(wrappedSpan.storeInContext(Context.current()));
            } else {
                otelSpanContext = io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext.createFromRemoteParent(traceId.toString(), parentSpanId.toString(), TraceFlags.getSampled(), TraceState.getDefault());
                wrappedSpan = Span.wrap(otelSpanContext);
                spanBuilder.setParent(wrappedSpan.storeInContext(Context.current()));
            }
        } else if (parentSpan instanceof IOtelSpanWrapper) {
            IOtelSpanWrapper parentSpanWrapper = (IOtelSpanWrapper)parentSpan;
            spanBuilder.setParent(parentSpanWrapper.storeInContext(Context.current()));
        }
        @Nullable Baggage baggage = spanContext.getBaggage();
        if (baggage != null) {
            spanBuilder.setAttribute(InternalSemanticAttributes.BAGGAGE_MUTABLE, Boolean.valueOf(baggage.isMutable()));
            spanBuilder.setAttribute(InternalSemanticAttributes.BAGGAGE, baggage.toHeaderString(null));
        }
        @NotNull SentryDate startTimestamp = (startTimestampFromOptions = spanOptions.getStartTimestamp()) == null ? scopes.getOptions().getDateProvider().now() : startTimestampFromOptions;
        spanBuilder.setStartTimestamp(startTimestamp.nanoTimestamp(), TimeUnit.NANOSECONDS);
        if (samplingDecision != null) {
            spanBuilder.setAttribute(InternalSemanticAttributes.SAMPLED, samplingDecision.getSampled());
            spanBuilder.setAttribute(InternalSemanticAttributes.SAMPLE_RATE, samplingDecision.getSampleRate());
            spanBuilder.setAttribute(InternalSemanticAttributes.SAMPLE_RAND, samplingDecision.getSampleRand());
            spanBuilder.setAttribute(InternalSemanticAttributes.PROFILE_SAMPLED, samplingDecision.getProfileSampled());
            spanBuilder.setAttribute(InternalSemanticAttributes.PROFILE_SAMPLE_RATE, samplingDecision.getProfileSampleRate());
        }
        if ((sentrySpan = this.storage.getSentrySpan((otelSpan = spanBuilder.startSpan()).getSpanContext())) != null) {
            @Nullable String description = spanContext.getDescription();
            if (description != null) {
                sentrySpan.setDescription(description);
            }
            if (spanContext instanceof TransactionContext) {
                @NotNull TransactionContext transactionContext = (TransactionContext)spanContext;
                sentrySpan.setTransactionName(transactionContext.getName(), transactionContext.getTransactionNameSource());
            }
            sentrySpan.getSpanContext().setOrigin(spanOptions.getOrigin());
        }
        if (sentrySpan == null) {
            return null;
        }
        return new OtelStrongRefSpanWrapper(otelSpan, sentrySpan);
    }

    @NotNull
    private Tracer getTracer() {
        return this.getTracerProvider().get("sentry-opentelemetry", "8.2.0");
    }

    @NotNull
    private TracerProvider getTracerProvider() {
        if (this.openTelemetry != null) {
            return this.openTelemetry.getTracerProvider();
        }
        return GlobalOpenTelemetry.getTracerProvider();
    }
}

