/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.sentry.IScopes;
import io.sentry.Sentry;
import io.sentry.opentelemetry.IOtelSpanWrapper;
import io.sentry.opentelemetry.SentryOtelKeys;
import io.sentry.opentelemetry.SentryWeakSpanStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryContextWrapper
implements Context {
    @NotNull
    private final Context delegate;

    private SentryContextWrapper(@NotNull Context delegate) {
        this.delegate = delegate;
    }

    @Override
    public <V> V get(@NotNull ContextKey<V> contextKey) {
        return this.delegate.get(contextKey);
    }

    @Override
    public <V> Context with(@NotNull ContextKey<V> contextKey, V v) {
        @NotNull Context modifiedContext = this.delegate.with(contextKey, v);
        if (this.isOpentelemetrySpan(contextKey)) {
            return SentryContextWrapper.forkCurrentScope(modifiedContext);
        }
        return modifiedContext;
    }

    private <V> boolean isOpentelemetrySpan(@NotNull ContextKey<V> contextKey) {
        return "opentelemetry-trace-span-key".equals(contextKey.toString());
    }

    @NotNull
    private static Context forkCurrentScope(@NotNull Context context) {
        @Nullable IOtelSpanWrapper sentrySpan = SentryContextWrapper.getCurrentSpanFromGlobalStorage(context);
        @Nullable IScopes spanScopes = sentrySpan == null ? null : sentrySpan.getScopes();
        @NotNull IScopes forkedScopes = SentryContextWrapper.forkCurrentScopeInternal(context, spanScopes);
        if (sentrySpan != null) {
            forkedScopes.setActiveSpan(sentrySpan);
        }
        return context.with(SentryOtelKeys.SENTRY_SCOPES_KEY, forkedScopes);
    }

    @NotNull
    private static IScopes forkCurrentScopeInternal(@NotNull Context context, @Nullable IScopes spanScopes) {
        @Nullable IScopes scopesInContext = context.get(SentryOtelKeys.SENTRY_SCOPES_KEY);
        if (scopesInContext != null && spanScopes != null && scopesInContext.isAncestorOf(spanScopes)) {
            return spanScopes.forkedCurrentScope("contextwrapper.spanancestor");
        }
        if (scopesInContext != null) {
            return scopesInContext.forkedCurrentScope("contextwrapper.scopeincontext");
        }
        if (spanScopes != null) {
            return spanScopes.forkedCurrentScope("contextwrapper.spanscope");
        }
        return Sentry.forkedRootScopes("contextwrapper.fallback");
    }

    @Nullable
    private static IOtelSpanWrapper getCurrentSpanFromGlobalStorage(@NotNull Context context) {
        @Nullable Span span = Span.fromContextOrNull(context);
        if (span != null) {
            @Nullable IOtelSpanWrapper sentrySpan = SentryWeakSpanStorage.getInstance().getSentrySpan(span.getSpanContext());
            return sentrySpan;
        }
        return null;
    }

    @NotNull
    public static SentryContextWrapper wrap(@NotNull Context context) {
        return new SentryContextWrapper(SentryContextWrapper.forkCurrentScope(context));
    }

    public String toString() {
        return this.delegate.toString();
    }
}

