/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadClass {
    @Nullable
    public Class<?> loadClass(@NotNull String clazz, @Nullable ILogger logger) {
        block6: {
            try {
                return Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                if (logger != null) {
                    logger.log(SentryLevel.DEBUG, "Class not available:" + clazz, e);
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (logger != null) {
                    logger.log(SentryLevel.ERROR, "Failed to load (UnsatisfiedLinkError) " + clazz, e);
                }
            }
            catch (Throwable e) {
                if (logger == null) break block6;
                logger.log(SentryLevel.ERROR, "Failed to initialize " + clazz, e);
            }
        }
        return null;
    }

    public boolean isClassAvailable(@NotNull String clazz, @Nullable ILogger logger) {
        return this.loadClass(clazz, logger) != null;
    }

    public boolean isClassAvailable(@NotNull String clazz, @Nullable SentryOptions options) {
        return this.isClassAvailable(clazz, options != null ? options.getLogger() : null);
    }
}

