/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.semconv.SemanticAttributes;
import io.sentry.Baggage;
import io.sentry.DsnUtil;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Instrumenter;
import io.sentry.PropagationContext;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.SentryLongDate;
import io.sentry.SentryOptions;
import io.sentry.SentrySpanStorage;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.opentelemetry.OtelSpanInfo;
import io.sentry.opentelemetry.SentryOtelKeys;
import io.sentry.opentelemetry.SpanDescriptionExtractor;
import io.sentry.opentelemetry.TraceData;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.TransactionNameSource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentrySpanProcessor
implements SpanProcessor {
    private static final String TRACE_ORIGN = "auto.otel";
    @NotNull
    private final List<SpanKind> spanKindsConsideredForSentryRequests = Arrays.asList(SpanKind.CLIENT, SpanKind.INTERNAL);
    @NotNull
    private final SpanDescriptionExtractor spanDescriptionExtractor = new SpanDescriptionExtractor();
    @NotNull
    private final SentrySpanStorage spanStorage = SentrySpanStorage.getInstance();
    @NotNull
    private final IHub hub;

    public SentrySpanProcessor() {
        this((IHub)HubAdapter.getInstance());
    }

    SentrySpanProcessor(@NotNull IHub hub) {
        this.hub = hub;
    }

    public void onStart(@NotNull Context parentContext, @NotNull ReadWriteSpan otelSpan) {
        ISpan sentryParentSpan;
        if (!this.ensurePrerequisites((ReadableSpan)otelSpan)) {
            return;
        }
        @NotNull TraceData traceData = this.getTraceData((ReadableSpan)otelSpan, parentContext);
        if (this.isSentryRequest((ReadableSpan)otelSpan)) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not forwarding OpenTelemetry span %s to Sentry as this looks like a span for a request to Sentry (trace %s).", new Object[]{traceData.getSpanId(), traceData.getTraceId()});
            return;
        }
        ISpan iSpan = sentryParentSpan = traceData.getParentSpanId() == null ? null : this.spanStorage.get(traceData.getParentSpanId());
        if (sentryParentSpan != null) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Creating Sentry child span for OpenTelemetry span %s (trace %s). Parent span is %s.", new Object[]{traceData.getSpanId(), traceData.getTraceId(), traceData.getParentSpanId()});
            @NotNull SentryLongDate startDate = new SentryLongDate(otelSpan.toSpanData().getStartEpochNanos());
            @NotNull ISpan sentryChildSpan = sentryParentSpan.startChild(otelSpan.getName(), otelSpan.getName(), (SentryDate)startDate, Instrumenter.OTEL);
            sentryChildSpan.getSpanContext().setOrigin(TRACE_ORIGN);
            this.spanStorage.store(traceData.getSpanId(), sentryChildSpan);
        } else {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Creating Sentry transaction for OpenTelemetry span %s (trace %s).", new Object[]{traceData.getSpanId(), traceData.getTraceId()});
            @NotNull String transactionName = otelSpan.getName();
            @NotNull TransactionNameSource transactionNameSource = TransactionNameSource.CUSTOM;
            @Nullable String op = otelSpan.getName();
            SpanId spanId = new SpanId(traceData.getSpanId());
            @NotNull TransactionContext transactionContext = traceData.getSentryTraceHeader() == null ? new TransactionContext(new SentryId(traceData.getTraceId()), spanId, null, null, null) : TransactionContext.fromPropagationContext((PropagationContext)PropagationContext.fromHeaders((SentryTraceHeader)traceData.getSentryTraceHeader(), (Baggage)traceData.getBaggage(), (SpanId)spanId));
            transactionContext.setName(transactionName);
            transactionContext.setTransactionNameSource(transactionNameSource);
            transactionContext.setOperation(op);
            transactionContext.setInstrumenter(Instrumenter.OTEL);
            TransactionOptions transactionOptions = new TransactionOptions();
            transactionOptions.setStartTimestamp((SentryDate)new SentryLongDate(otelSpan.toSpanData().getStartEpochNanos()));
            ITransaction sentryTransaction = this.hub.startTransaction(transactionContext, transactionOptions);
            sentryTransaction.getSpanContext().setOrigin(TRACE_ORIGN);
            this.spanStorage.store(traceData.getSpanId(), (ISpan)sentryTransaction);
        }
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(@NotNull ReadableSpan otelSpan) {
        if (!this.ensurePrerequisites(otelSpan)) {
            return;
        }
        @NotNull TraceData traceData = this.getTraceData(otelSpan, null);
        @Nullable ISpan sentrySpan = this.spanStorage.removeAndGet(traceData.getSpanId());
        if (sentrySpan == null) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Unable to find Sentry span for OpenTelemetry span %s (trace %s). This may simply mean it is a Sentry request.", new Object[]{traceData.getSpanId(), traceData.getTraceId()});
            return;
        }
        if (this.isSentryRequest(otelSpan)) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not forwarding OpenTelemetry span %s to Sentry as this looks like a span for a request to Sentry (trace %s).", new Object[]{traceData.getSpanId(), traceData.getTraceId()});
            return;
        }
        if (sentrySpan instanceof ITransaction) {
            @NotNull ITransaction sentryTransaction = (ITransaction)sentrySpan;
            this.updateTransactionWithOtelData(sentryTransaction, otelSpan);
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Finishing Sentry transaction %s for OpenTelemetry span %s (trace %s).", new Object[]{sentryTransaction.getEventId(), traceData.getSpanId(), traceData.getTraceId()});
        } else {
            this.updateSpanWithOtelData(sentrySpan, otelSpan);
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Finishing Sentry span for OpenTelemetry span %s (trace %s). Parent span is %s.", new Object[]{traceData.getSpanId(), traceData.getTraceId(), traceData.getParentSpanId()});
        }
        @NotNull SpanStatus sentryStatus = this.mapOtelStatus(otelSpan);
        @NotNull SentryLongDate endTimestamp = new SentryLongDate(otelSpan.toSpanData().getEndEpochNanos());
        sentrySpan.finish(sentryStatus, (SentryDate)endTimestamp);
    }

    public boolean isEndRequired() {
        return true;
    }

    private boolean ensurePrerequisites(@NotNull ReadableSpan otelSpan) {
        if (!this.hasSentryBeenInitialized()) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not forwarding OpenTelemetry span to Sentry as Sentry has not yet been initialized.", new Object[0]);
            return false;
        }
        @NotNull Instrumenter instrumenter = this.hub.getOptions().getInstrumenter();
        if (!Instrumenter.OTEL.equals((Object)instrumenter)) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not forwarding OpenTelemetry span to Sentry as instrumenter has been set to %s.", new Object[]{instrumenter});
            return false;
        }
        @NotNull SpanContext otelSpanContext = otelSpan.getSpanContext();
        if (!otelSpanContext.isValid()) {
            this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, "Not forwarding OpenTelemetry span to Sentry as the span is invalid.", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean isSentryRequest(@NotNull ReadableSpan otelSpan) {
        @NotNull SpanKind kind = otelSpan.getKind();
        if (!this.spanKindsConsideredForSentryRequests.contains(kind)) {
            return false;
        }
        @Nullable String httpUrl = (String)otelSpan.getAttribute(SemanticAttributes.HTTP_URL);
        return DsnUtil.urlContainsDsnHost((SentryOptions)this.hub.getOptions(), (String)httpUrl);
    }

    @NotNull
    private TraceData getTraceData(@NotNull ReadableSpan otelSpan, @Nullable Context parentContext) {
        @NotNull SpanContext otelSpanContext = otelSpan.getSpanContext();
        @NotNull String otelSpanId = otelSpanContext.getSpanId();
        @NotNull String otelParentSpanIdMaybeInvalid = otelSpan.getParentSpanContext().getSpanId();
        @NotNull String otelTraceId = otelSpanContext.getTraceId();
        String otelParentSpanId = io.opentelemetry.api.trace.SpanId.isValid((CharSequence)otelParentSpanIdMaybeInvalid) ? otelParentSpanIdMaybeInvalid : null;
        SentryTraceHeader sentryTraceHeader = null;
        Baggage baggage = null;
        if (parentContext != null && (sentryTraceHeader = (SentryTraceHeader)parentContext.get(SentryOtelKeys.SENTRY_TRACE_KEY)) != null) {
            baggage = (Baggage)parentContext.get(SentryOtelKeys.SENTRY_BAGGAGE_KEY);
        }
        return new TraceData(otelTraceId, otelSpanId, otelParentSpanId, sentryTraceHeader, baggage);
    }

    private void updateTransactionWithOtelData(@NotNull ITransaction sentryTransaction, @NotNull ReadableSpan otelSpan) {
        @NotNull OtelSpanInfo otelSpanInfo = this.spanDescriptionExtractor.extractSpanDescription(otelSpan);
        sentryTransaction.setOperation(otelSpanInfo.getOp());
        sentryTransaction.setName(otelSpanInfo.getDescription(), otelSpanInfo.getTransactionNameSource());
        @NotNull Map<String, Object> otelContext = this.toOtelContext(otelSpan);
        sentryTransaction.setContext("otel", otelContext);
    }

    @NotNull
    private Map<String, Object> toOtelContext(@NotNull ReadableSpan otelSpan) {
        @NotNull SpanData spanData = otelSpan.toSpanData();
        @NotNull HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("attributes", this.toMapWithStringKeys(spanData.getAttributes()));
        context.put("resource", this.toMapWithStringKeys(spanData.getResource().getAttributes()));
        return context;
    }

    private void updateSpanWithOtelData(@NotNull ISpan sentrySpan, @NotNull ReadableSpan otelSpan) {
        @NotNull SpanData spanData = otelSpan.toSpanData();
        sentrySpan.setData("otel.kind", (Object)otelSpan.getKind());
        spanData.getAttributes().forEach((attributeKey, value) -> {
            if (value != null) {
                sentrySpan.setData(attributeKey.getKey(), value);
            }
        });
        @NotNull OtelSpanInfo otelSpanInfo = this.spanDescriptionExtractor.extractSpanDescription(otelSpan);
        sentrySpan.setOperation(otelSpanInfo.getOp());
        sentrySpan.setDescription(otelSpanInfo.getDescription());
    }

    private SpanStatus mapOtelStatus(@NotNull ReadableSpan otelSpan) {
        SpanStatus spanStatus;
        @NotNull SpanData otelSpanData = otelSpan.toSpanData();
        @NotNull StatusData otelStatus = otelSpanData.getStatus();
        @NotNull StatusCode otelStatusCode = otelStatus.getStatusCode();
        if (StatusCode.OK.equals((Object)otelStatusCode) || StatusCode.UNSET.equals((Object)otelStatusCode)) {
            return SpanStatus.OK;
        }
        @Nullable Long httpStatus = (Long)otelSpan.getAttribute(SemanticAttributes.HTTP_STATUS_CODE);
        if (httpStatus != null && (spanStatus = SpanStatus.fromHttpStatusCode((int)httpStatus.intValue())) != null) {
            return spanStatus;
        }
        return SpanStatus.UNKNOWN_ERROR;
    }

    private boolean hasSentryBeenInitialized() {
        return this.hub.isEnabled();
    }

    @NotNull
    private Map<String, Object> toMapWithStringKeys(@Nullable Attributes attributes) {
        @NotNull HashMap<String, Object> mapWithStringKeys = new HashMap<String, Object>();
        if (attributes != null) {
            attributes.forEach((key, value) -> {
                if (key != null) {
                    mapWithStringKeys.put(key.getKey(), value);
                }
            });
        }
        return mapWithStringKeys;
    }
}

