/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.opentelemetry;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.semconv.SemanticAttributes;
import io.sentry.opentelemetry.OtelSpanInfo;
import io.sentry.protocol.TransactionNameSource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SpanDescriptionExtractor {
    @NotNull
    public OtelSpanInfo extractSpanDescription(@NotNull ReadableSpan otelSpan) {
        @NotNull String name = otelSpan.getName();
        @Nullable String httpMethod = (String)otelSpan.getAttribute(SemanticAttributes.HTTP_METHOD);
        if (httpMethod != null) {
            return this.descriptionForHttpMethod(otelSpan, httpMethod);
        }
        @Nullable String dbSystem = (String)otelSpan.getAttribute(SemanticAttributes.DB_SYSTEM);
        if (dbSystem != null) {
            return this.descriptionForDbSystem(otelSpan);
        }
        return new OtelSpanInfo(name, name, TransactionNameSource.CUSTOM);
    }

    private OtelSpanInfo descriptionForHttpMethod(@NotNull ReadableSpan otelSpan, @NotNull String httpMethod) {
        @NotNull String name = otelSpan.getName();
        @NotNull SpanKind kind = otelSpan.getKind();
        @NotNull StringBuilder opBuilder = new StringBuilder("http");
        if (SpanKind.CLIENT.equals((Object)kind)) {
            opBuilder.append(".client");
        } else if (SpanKind.SERVER.equals((Object)kind)) {
            opBuilder.append(".server");
        }
        @Nullable String httpTarget = (String)otelSpan.getAttribute(SemanticAttributes.HTTP_TARGET);
        @Nullable String httpRoute = (String)otelSpan.getAttribute(SemanticAttributes.HTTP_ROUTE);
        @Nullable String httpPath = httpRoute != null ? httpRoute : httpTarget;
        @NotNull String op = opBuilder.toString();
        if (httpPath == null) {
            return new OtelSpanInfo(op, name, TransactionNameSource.CUSTOM);
        }
        @NotNull String description = httpMethod + " " + httpPath;
        @NotNull TransactionNameSource transactionNameSource = httpRoute != null ? TransactionNameSource.ROUTE : TransactionNameSource.URL;
        return new OtelSpanInfo(op, description, transactionNameSource);
    }

    private OtelSpanInfo descriptionForDbSystem(@NotNull ReadableSpan otelSpan) {
        @Nullable String dbStatement = (String)otelSpan.getAttribute(SemanticAttributes.DB_STATEMENT);
        @NotNull String description = dbStatement != null ? dbStatement : otelSpan.getName();
        return new OtelSpanInfo("db", description, TransactionNameSource.TASK);
    }
}

