/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.quartz;

import io.sentry.CheckIn;
import io.sentry.CheckInStatus;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ScopesAdapter;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.protocol.SentryId;
import io.sentry.util.LifecycleHelper;
import io.sentry.util.Objects;
import io.sentry.util.TracingUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

@ApiStatus.Experimental
public final class SentryJobListener
implements JobListener {
    public static final String SENTRY_CHECK_IN_ID_KEY = "sentry-checkin-id";
    public static final String SENTRY_SLUG_KEY = "sentry-slug";
    public static final String SENTRY_SCOPE_LIFECYCLE_TOKEN_KEY = "sentry-scope-lifecycle";
    @NotNull
    private final IScopes scopes;

    public SentryJobListener() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    public SentryJobListener(@NotNull IScopes scopes) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
        SentryIntegrationPackageStorage.getInstance().addIntegration("Quartz");
    }

    public String getName() {
        return "sentry-job-listener";
    }

    public void jobToBeExecuted(@NotNull JobExecutionContext context) {
        try {
            @Nullable String maybeSlug = this.getSlug(context);
            if (maybeSlug == null) {
                return;
            }
            @NotNull ISentryLifecycleToken lifecycleToken = this.scopes.forkedScopes("SentryJobListener").makeCurrent();
            TracingUtils.startNewTrace((IScopes)this.scopes);
            String slug = maybeSlug;
            @NotNull CheckIn checkIn = new CheckIn(slug, CheckInStatus.IN_PROGRESS);
            @NotNull SentryId checkInId = this.scopes.captureCheckIn(checkIn);
            context.put((Object)SENTRY_CHECK_IN_ID_KEY, (Object)checkInId);
            context.put((Object)SENTRY_SLUG_KEY, (Object)slug);
            context.put((Object)SENTRY_SCOPE_LIFECYCLE_TOKEN_KEY, (Object)lifecycleToken);
        }
        catch (Throwable t) {
            this.scopes.getOptions().getLogger().log(SentryLevel.ERROR, "Unable to capture check-in in jobToBeExecuted.", t);
        }
    }

    @Nullable
    private String getSlug(@NotNull JobExecutionContext context) {
        Object o;
        @Nullable JobDataMap jobDataMap = context.getMergedJobDataMap();
        if (jobDataMap != null && (o = jobDataMap.get((Object)SENTRY_SLUG_KEY)) != null) {
            return o.toString();
        }
        return null;
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        try {
            String slug;
            @Nullable Object checkInIdObjectFromContext = context.get((Object)SENTRY_CHECK_IN_ID_KEY);
            @Nullable Object slugObjectFromContext = context.get((Object)SENTRY_SLUG_KEY);
            @NotNull SentryId checkInId = checkInIdObjectFromContext == null ? new SentryId() : (SentryId)checkInIdObjectFromContext;
            String string = slug = slugObjectFromContext == null ? null : (String)slugObjectFromContext;
            if (slug != null) {
                boolean isFailed = jobException != null;
                @NotNull CheckInStatus status = isFailed ? CheckInStatus.ERROR : CheckInStatus.OK;
                this.scopes.captureCheckIn(new CheckIn(checkInId, slug, status));
            }
        }
        catch (Throwable t) {
            this.scopes.getOptions().getLogger().log(SentryLevel.ERROR, "Unable to capture check-in in jobWasExecuted.", t);
        }
        finally {
            LifecycleHelper.close((Object)context.get((Object)SENTRY_SCOPE_LIFECYCLE_TOKEN_KEY));
        }
    }

    static {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-quartz", "8.19.0");
    }
}

