/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.reactor;

import io.sentry.IScopes;
import io.sentry.Sentry;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class SentryReactorUtils {
    public static <T> Mono<T> withSentry(@NotNull Mono<T> mono) {
        @NotNull IScopes oldScopes = Sentry.getCurrentScopes();
        @NotNull IScopes forkedScopes = oldScopes.forkedCurrentScope("reactor.withSentry");
        return SentryReactorUtils.withSentryScopes(mono, forkedScopes);
    }

    public static <T> Mono<T> withSentryForkedRoots(@NotNull Mono<T> mono) {
        @NotNull IScopes scopes = Sentry.forkedRootScopes((String)"reactor");
        return SentryReactorUtils.withSentryScopes(mono, scopes);
    }

    public static <T> Mono<T> withSentryScopes(@NotNull Mono<T> mono, @NotNull IScopes scopes) {
        return Mono.deferContextual(ctx -> mono).contextWrite((ContextView)Context.of((Object)"sentry-scopes", (Object)scopes));
    }

    public static <T> Flux<T> withSentry(@NotNull Flux<T> flux) {
        @NotNull IScopes oldScopes = Sentry.getCurrentScopes();
        @NotNull IScopes forkedScopes = oldScopes.forkedCurrentScope("reactor.withSentry");
        return SentryReactorUtils.withSentryScopes(flux, forkedScopes);
    }

    public static <T> Flux<T> withSentryForkedRoots(@NotNull Flux<T> flux) {
        @NotNull IScopes scopes = Sentry.forkedRootScopes((String)"reactor");
        return SentryReactorUtils.withSentryScopes(flux, scopes);
    }

    public static <T> Flux<T> withSentryScopes(@NotNull Flux<T> flux, @NotNull IScopes scopes) {
        return Flux.deferContextual(ctx -> flux).contextWrite((ContextView)Context.of((Object)"sentry-scopes", (Object)scopes));
    }
}

