/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot.jakarta;

import io.micrometer.context.ThreadLocalAccessor;
import io.sentry.IHub;
import io.sentry.spring.boot.jakarta.SentryAutoConfiguration;
import io.sentry.spring.jakarta.webflux.SentryScheduleHook;
import io.sentry.spring.jakarta.webflux.SentryWebExceptionHandler;
import io.sentry.spring.jakarta.webflux.SentryWebFilter;
import io.sentry.spring.jakarta.webflux.SentryWebFilterWithThreadLocalAccessor;
import io.sentry.spring.jakarta.webflux.SentryWebTracingFilter;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnBean(value={IHub.class})
@ConditionalOnClass(value={Schedulers.class})
@ApiStatus.Experimental
public class SentryWebfluxAutoConfiguration {
    private static final int SENTRY_SPRING_FILTER_PRECEDENCE = Integer.MIN_VALUE;

    @Bean
    @Order(value=-2147483647)
    @Conditional(value={SentryAutoConfiguration.SentryTracingCondition.class})
    @ConditionalOnMissingBean(name={"sentryWebTracingFilter"})
    @NotNull
    public SentryWebTracingFilter sentryWebTracingFilter() {
        return new SentryWebTracingFilter();
    }

    @Bean
    @NotNull
    public SentryWebExceptionHandler sentryWebExceptionHandler(@NotNull IHub hub) {
        return new SentryWebExceptionHandler(hub);
    }

    static final class SentryThreadLocalAccessorCondition
    extends AllNestedConditions {
        public SentryThreadLocalAccessorCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnClass(value={ThreadLocalAccessor.class})
        private static class ThreadLocalAccessorClassCondition {
            private ThreadLocalAccessorClassCondition() {
            }
        }

        @ConditionalOnProperty(name={"sentry.reactive.thread-local-accessor-enabled"}, havingValue="true")
        private static class SentryEnableThreadLocalAccessorCondition {
            private SentryEnableThreadLocalAccessorCondition() {
            }
        }
    }

    static final class SentryLegacyFilterConfigurationCondition
    extends AnyNestedCondition {
        public SentryLegacyFilterConfigurationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingClass(value={"io.micrometer.context.ThreadLocalAccessor"})
        private static class ThreadLocalAccessorClassCondition {
            private ThreadLocalAccessorClassCondition() {
            }
        }

        @ConditionalOnProperty(name={"sentry.reactive.thread-local-accessor-enabled"}, havingValue="false", matchIfMissing=true)
        private static class SentryDisableThreadLocalAccessorCondition {
            private SentryDisableThreadLocalAccessorCondition() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={SentryLegacyFilterConfigurationCondition.class})
    static class SentryWebfluxFilterConfiguration {
        SentryWebfluxFilterConfiguration() {
        }

        @Bean
        @NotNull
        public ApplicationRunner sentryScheduleHookApplicationRunner() {
            return args -> Schedulers.onScheduleHook((String)"sentry", (Function)new SentryScheduleHook());
        }

        @Bean
        @Order(value=-2147483648)
        @NotNull
        public SentryWebFilter sentryWebFilter(@NotNull IHub hub) {
            return new SentryWebFilter(hub);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={SentryThreadLocalAccessorCondition.class})
    static class SentryWebfluxFilterThreadLocalAccessorConfiguration {
        SentryWebfluxFilterThreadLocalAccessorConfiguration() {
        }

        @Bean
        @Order(value=-2147483648)
        @NotNull
        public SentryWebFilterWithThreadLocalAccessor sentryWebFilterWithContextPropagation(@NotNull IHub hub) {
            Hooks.enableAutomaticContextPropagation();
            return new SentryWebFilterWithThreadLocalAccessor(hub);
        }
    }
}

