/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.IHub;
import io.sentry.NoOpHub;
import io.sentry.Sentry;
import io.sentry.spring.jakarta.webflux.AbstractSentryWebFilter;
import io.sentry.spring.jakarta.webflux.ReactorUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@ApiStatus.Experimental
public final class SentryWebFilterWithThreadLocalAccessor
extends AbstractSentryWebFilter {
    public SentryWebFilterWithThreadLocalAccessor(@NotNull IHub hub) {
        super(hub);
    }

    public Mono<Void> filter(@NotNull ServerWebExchange serverWebExchange, @NotNull WebFilterChain webFilterChain) {
        return ReactorUtils.withSentryNewMainHubClone(webFilterChain.filter(serverWebExchange).doFinally(__ -> {
            this.doFinally(Sentry.getCurrentHub());
            Sentry.setCurrentHub((IHub)NoOpHub.getInstance());
        }).doFirst(() -> this.doFirst(serverWebExchange, Sentry.getCurrentHub())));
    }
}

