/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.checkin;

import io.sentry.CheckIn;
import io.sentry.CheckInStatus;
import io.sentry.DateUtils;
import io.sentry.IHub;
import io.sentry.SentryLevel;
import io.sentry.protocol.SentryId;
import io.sentry.spring.jakarta.checkin.SentryCheckIn;
import io.sentry.util.Objects;
import io.sentry.util.TracingUtils;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;

@ApiStatus.Internal
@ApiStatus.Experimental
public class SentryCheckInAdvice
implements MethodInterceptor {
    @NotNull
    private final IHub hub;

    public SentryCheckInAdvice(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        CheckInStatus status;
        Object object;
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass());
        @Nullable SentryCheckIn checkInAnnotation = (SentryCheckIn)AnnotationUtils.findAnnotation((Method)mostSpecificMethod, SentryCheckIn.class);
        if (checkInAnnotation == null) {
            return invocation.proceed();
        }
        boolean isHeartbeatOnly = checkInAnnotation.heartbeat();
        @Nullable String monitorSlug = checkInAnnotation.value();
        if (ObjectUtils.isEmpty((Object)monitorSlug)) {
            this.hub.getOptions().getLogger().log(SentryLevel.WARNING, "Not capturing check-in for method annotated with @SentryCheckIn because it does not specify a monitor slug.", new Object[0]);
            return invocation.proceed();
        }
        this.hub.pushScope();
        TracingUtils.startNewTrace((IHub)this.hub);
        SentryId checkInId = null;
        long startTime = System.currentTimeMillis();
        boolean didError = false;
        try {
            if (!isHeartbeatOnly) {
                checkInId = this.hub.captureCheckIn(new CheckIn(monitorSlug, CheckInStatus.IN_PROGRESS));
            }
            object = invocation.proceed();
            status = didError ? CheckInStatus.ERROR : CheckInStatus.OK;
        }
        catch (Throwable e) {
            try {
                didError = true;
                throw e;
            }
            catch (Throwable throwable) {
                @NotNull CheckInStatus status2 = didError ? CheckInStatus.ERROR : CheckInStatus.OK;
                CheckIn checkIn = new CheckIn(checkInId, monitorSlug, status2);
                checkIn.setDuration(Double.valueOf(DateUtils.millisToSeconds((double)(System.currentTimeMillis() - startTime))));
                this.hub.captureCheckIn(checkIn);
                this.hub.popScope();
                throw throwable;
            }
        }
        CheckIn checkIn = new CheckIn(checkInId, monitorSlug, status);
        checkIn.setDuration(Double.valueOf(DateUtils.millisToSeconds((double)(System.currentTimeMillis() - startTime))));
        this.hub.captureCheckIn(checkIn);
        this.hub.popScope();
        return object;
    }
}

