/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import io.sentry.util.CollectionUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;

public final class ContextTagsEventProcessor
implements EventProcessor {
    private final SentryOptions options;

    public ContextTagsEventProcessor(@NotNull SentryOptions options) {
        this.options = options;
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @Nullable Hint hint) {
        Map mdcProperties;
        Map contextMap = MDC.getCopyOfContextMap();
        if (contextMap != null && !(mdcProperties = CollectionUtils.filterMapEntries((Map)contextMap, entry -> entry.getValue() != null)).isEmpty() && !this.options.getContextTags().isEmpty()) {
            for (String contextTag : this.options.getContextTags()) {
                if (!mdcProperties.containsKey(contextTag)) continue;
                event.setTag(contextTag, (String)mdcProperties.get(contextTag));
            }
        }
        return event;
    }
}

