/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.spring.jakarta.CachedBodyServletInputStream;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.StreamUtils;

final class CachedBodyHttpServletRequest
extends HttpServletRequestWrapper {
    @NotNull
    private final byte[] cachedBody;

    public CachedBodyHttpServletRequest(@NotNull HttpServletRequest request) throws IOException {
        super(request);
        this.cachedBody = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    @NotNull
    public ServletInputStream getInputStream() {
        return new CachedBodyServletInputStream(this.cachedBody);
    }

    @NotNull
    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.cachedBody), StandardCharsets.UTF_8));
    }
}

