/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.graphql;

import graphql.GraphQLContext;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.NoOpHub;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ApiStatus.Internal
public final class SentryBatchLoaderRegistry
implements BatchLoaderRegistry {
    @NotNull
    private final BatchLoaderRegistry delegate;

    SentryBatchLoaderRegistry(@NotNull BatchLoaderRegistry delegate) {
        this.delegate = delegate;
    }

    public <K, V> BatchLoaderRegistry.RegistrationSpec<K, V> forTypePair(Class<K> keyType, Class<V> valueType) {
        return new SentryRegistrationSpec<K, V>(this.delegate.forTypePair(keyType, valueType), keyType, valueType);
    }

    public <K, V> BatchLoaderRegistry.RegistrationSpec<K, V> forName(String name) {
        return new SentryRegistrationSpec(this.delegate.forName(name), name);
    }

    public void registerDataLoaders(DataLoaderRegistry registry, GraphQLContext context) {
        this.delegate.registerDataLoaders(registry, context);
    }

    public static final class SentryRegistrationSpec<K, V>
    implements BatchLoaderRegistry.RegistrationSpec<K, V> {
        @NotNull
        private final BatchLoaderRegistry.RegistrationSpec<K, V> delegate;
        @Nullable
        private final String name;
        @Nullable
        private final Class<K> keyType;
        @Nullable
        private final Class<V> valueType;

        public SentryRegistrationSpec(@NotNull BatchLoaderRegistry.RegistrationSpec<K, V> delegate, Class<K> keyType, Class<V> valueType) {
            this.delegate = delegate;
            this.keyType = keyType;
            this.valueType = valueType;
            this.name = null;
        }

        public SentryRegistrationSpec(@NotNull BatchLoaderRegistry.RegistrationSpec<K, V> delegate, String name) {
            this.delegate = delegate;
            this.name = name;
            this.keyType = null;
            this.valueType = null;
        }

        public BatchLoaderRegistry.RegistrationSpec<K, V> withName(String name) {
            return this.delegate.withName(name);
        }

        public BatchLoaderRegistry.RegistrationSpec<K, V> withOptions(Consumer<DataLoaderOptions> optionsConsumer) {
            return this.delegate.withOptions(optionsConsumer);
        }

        public BatchLoaderRegistry.RegistrationSpec<K, V> withOptions(DataLoaderOptions options) {
            return this.delegate.withOptions(options);
        }

        public void registerBatchLoader(BiFunction<List<K>, BatchLoaderEnvironment, Flux<V>> loader) {
            this.delegate.registerBatchLoader((keys, batchLoaderEnvironment) -> {
                this.hubFromContext((BatchLoaderEnvironment)batchLoaderEnvironment).addBreadcrumb(Breadcrumb.graphqlDataLoader((Iterable)keys, this.keyType, this.valueType, (String)this.name));
                return (Flux)loader.apply((List<K>)keys, (BatchLoaderEnvironment)batchLoaderEnvironment);
            });
        }

        public void registerMappedBatchLoader(BiFunction<Set<K>, BatchLoaderEnvironment, Mono<Map<K, V>>> loader) {
            this.delegate.registerMappedBatchLoader((keys, batchLoaderEnvironment) -> {
                this.hubFromContext((BatchLoaderEnvironment)batchLoaderEnvironment).addBreadcrumb(Breadcrumb.graphqlDataLoader((Iterable)keys, this.keyType, this.valueType, (String)this.name));
                return (Mono)loader.apply((Set<K>)keys, (BatchLoaderEnvironment)batchLoaderEnvironment);
            });
        }

        @NotNull
        private IHub hubFromContext(@NotNull BatchLoaderEnvironment environment) {
            Object context = environment.getContext();
            if (context instanceof GraphQLContext) {
                GraphQLContext graphqlContext = (GraphQLContext)context;
                return (IHub)graphqlContext.getOrDefault((Object)"sentry.hub", (Object)NoOpHub.getInstance());
            }
            return NoOpHub.getInstance();
        }
    }
}

