/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.checkin;

import io.sentry.CheckIn;
import io.sentry.CheckInStatus;
import io.sentry.DateUtils;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ScopesAdapter;
import io.sentry.SentryLevel;
import io.sentry.protocol.SentryId;
import io.sentry.spring.jakarta.checkin.SentryCheckIn;
import io.sentry.util.Objects;
import io.sentry.util.TracingUtils;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringValueResolver;

@ApiStatus.Internal
@ApiStatus.Experimental
public class SentryCheckInAdvice
implements MethodInterceptor,
EmbeddedValueResolverAware {
    @NotNull
    private final IScopes scopes;
    @Nullable
    private StringValueResolver resolver;

    public SentryCheckInAdvice() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    public SentryCheckInAdvice(@NotNull IScopes scopes) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
    }

    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass());
        @Nullable SentryCheckIn checkInAnnotation = (SentryCheckIn)AnnotationUtils.findAnnotation((Method)mostSpecificMethod, SentryCheckIn.class);
        if (checkInAnnotation == null) {
            return invocation.proceed();
        }
        boolean isHeartbeatOnly = checkInAnnotation.heartbeat();
        @Nullable String monitorSlug = checkInAnnotation.value();
        if (this.resolver != null) {
            try {
                monitorSlug = this.resolver.resolveStringValue(checkInAnnotation.value());
            }
            catch (Throwable e) {
                this.scopes.getOptions().getLogger().log(SentryLevel.WARNING, "Slug for method annotated with @SentryCheckIn could not be resolved from properties.", e);
            }
        }
        if (ObjectUtils.isEmpty((Object)monitorSlug)) {
            this.scopes.getOptions().getLogger().log(SentryLevel.WARNING, "Not capturing check-in for method annotated with @SentryCheckIn because it does not specify a monitor slug.", new Object[0]);
            return invocation.proceed();
        }
        try (@NotNull ISentryLifecycleToken ignored = this.scopes.forkedScopes("SentryCheckInAdvice").makeCurrent();){
            CheckInStatus status;
            Object object;
            TracingUtils.startNewTrace((IScopes)this.scopes);
            SentryId checkInId = null;
            long startTime = System.currentTimeMillis();
            boolean didError = false;
            try {
                if (!isHeartbeatOnly) {
                    checkInId = this.scopes.captureCheckIn(new CheckIn(monitorSlug, CheckInStatus.IN_PROGRESS));
                }
                object = invocation.proceed();
                status = didError ? CheckInStatus.ERROR : CheckInStatus.OK;
            }
            catch (Throwable e) {
                try {
                    didError = true;
                    throw e;
                }
                catch (Throwable throwable) {
                    @NotNull CheckInStatus status2 = didError ? CheckInStatus.ERROR : CheckInStatus.OK;
                    CheckIn checkIn = new CheckIn(checkInId, monitorSlug, status2);
                    checkIn.setDuration(Double.valueOf(DateUtils.millisToSeconds((double)(System.currentTimeMillis() - startTime))));
                    this.scopes.captureCheckIn(checkIn);
                    throw throwable;
                }
            }
            CheckIn checkIn = new CheckIn(checkInId, monitorSlug, status);
            checkIn.setDuration(Double.valueOf(DateUtils.millisToSeconds((double)(System.currentTimeMillis() - startTime))));
            this.scopes.captureCheckIn(checkIn);
            return object;
        }
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }
}

