/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.SentryOptions;
import io.sentry.protocol.Request;
import io.sentry.util.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryRequestResolver {
    private static final List<String> SENSITIVE_HEADERS = Arrays.asList("X-FORWARDED-FOR", "AUTHORIZATION", "COOKIE");
    @NotNull
    private final SentryOptions options;

    public SentryRequestResolver(@NotNull SentryOptions options) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options is required");
    }

    @NotNull
    public Request resolveSentryRequest(@NotNull HttpServletRequest httpRequest) {
        Request sentryRequest = new Request();
        sentryRequest.setMethod(httpRequest.getMethod());
        sentryRequest.setQueryString(httpRequest.getQueryString());
        sentryRequest.setUrl(httpRequest.getRequestURL().toString());
        sentryRequest.setHeaders(this.resolveHeadersMap(httpRequest));
        if (this.options.isSendDefaultPii()) {
            sentryRequest.setCookies(SentryRequestResolver.toString(httpRequest.getHeaders("Cookie")));
        }
        return sentryRequest;
    }

    @NotNull
    Map<String, String> resolveHeadersMap(@NotNull HttpServletRequest request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            if (!this.options.isSendDefaultPii() && SENSITIVE_HEADERS.contains(headerName.toUpperCase())) continue;
            headersMap.put(headerName, SentryRequestResolver.toString(request.getHeaders(headerName)));
        }
        return headersMap;
    }

    @Nullable
    private static String toString(@Nullable Enumeration<String> enumeration) {
        return enumeration != null ? String.join((CharSequence)",", Collections.list(enumeration)) : null;
    }
}

