/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.Span;
import io.sentry.SpanStatus;
import io.sentry.spring.tracing.SentrySpan;
import io.sentry.util.Objects;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class SentrySpanAdvice
implements MethodInterceptor {
    @NotNull
    private final IHub hub;

    public SentrySpanAdvice(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        ISpan activeSpan = this.resolveActiveSpan();
        if (activeSpan == null) {
            return invocation.proceed();
        }
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass());
        Class<?> targetClass = invocation.getMethod().getDeclaringClass();
        Span span = activeSpan.startChild();
        SentrySpan sentrySpan = (SentrySpan)AnnotationUtils.findAnnotation((Method)mostSpecificMethod, SentrySpan.class);
        span.setDescription(this.resolveSpanDescription(targetClass, mostSpecificMethod, sentrySpan));
        if (sentrySpan != null && !StringUtils.isEmpty((Object)sentrySpan.op())) {
            span.setOperation(sentrySpan.op());
        }
        try {
            Object result = invocation.proceed();
            span.setStatus(SpanStatus.OK);
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            span.setStatus(SpanStatus.INTERNAL_ERROR);
            span.setThrowable(e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    private String resolveSpanDescription(Class<?> targetClass, Method method, @Nullable SentrySpan sentrySpan) {
        return sentrySpan == null || StringUtils.isEmpty((Object)sentrySpan.value()) ? targetClass.getSimpleName() + "." + method.getName() : sentrySpan.value();
    }

    @Nullable
    private ISpan resolveActiveSpan() {
        AtomicReference spanRef = new AtomicReference();
        this.hub.configureScope(scope -> {
            ISpan span = scope.getSpan();
            if (span != null) {
                spanRef.set(span);
            }
        });
        return (ISpan)spanRef.get();
    }
}

