/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.Breadcrumb;
import io.sentry.EventProcessor;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.spring.CachedBodyHttpServletRequest;
import io.sentry.spring.RequestPayloadExtractor;
import io.sentry.spring.SentryRequestHttpServletRequestProcessor;
import io.sentry.spring.SentryRequestResolver;
import io.sentry.spring.tracing.SpringMvcTransactionNameProvider;
import io.sentry.spring.tracing.TransactionNameProvider;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import org.springframework.web.filter.OncePerRequestFilter;

public class SentrySpringFilter
extends OncePerRequestFilter {
    @NotNull
    private final IHub hub;
    @NotNull
    private final SentryRequestResolver requestResolver;
    @NotNull
    private final TransactionNameProvider transactionNameProvider;

    public SentrySpringFilter(@NotNull IHub hub, @NotNull SentryRequestResolver requestResolver, @NotNull TransactionNameProvider transactionNameProvider) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.requestResolver = (SentryRequestResolver)Objects.requireNonNull((Object)requestResolver, (String)"requestResolver is required");
        this.transactionNameProvider = (TransactionNameProvider)Objects.requireNonNull((Object)transactionNameProvider, (String)"transactionNameProvider is required");
    }

    public SentrySpringFilter(@NotNull IHub hub) {
        this(hub, new SentryRequestResolver(hub), new SpringMvcTransactionNameProvider());
    }

    public SentrySpringFilter() {
        this((IHub)HubAdapter.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NotNull HttpServletRequest servletRequest, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        if (this.hub.isEnabled()) {
            HttpServletRequest request = this.resolveHttpServletRequest(servletRequest);
            this.hub.pushScope();
            try {
                HashMap<String, Object> hintMap = new HashMap<String, Object>();
                hintMap.put("springRequestFilter:request", servletRequest);
                hintMap.put("springRequestFilter:response", response);
                this.hub.addBreadcrumb(Breadcrumb.http((String)request.getRequestURI(), (String)request.getMethod()), hintMap);
                this.configureScope(request);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                this.hub.popScope();
            }
        } else {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)response);
        }
    }

    private void configureScope(HttpServletRequest request) {
        try {
            this.hub.configureScope(scope -> {
                scope.setRequest(this.requestResolver.resolveSentryRequest(request));
                scope.addEventProcessor((EventProcessor)new SentryRequestHttpServletRequestProcessor(this.transactionNameProvider, request));
                if (request instanceof CachedBodyHttpServletRequest) {
                    scope.addEventProcessor((EventProcessor)new RequestBodyExtractingEventProcessor(request, this.hub.getOptions()));
                }
            });
        }
        catch (Throwable e) {
            this.hub.getOptions().getLogger().log(SentryLevel.ERROR, "Failed to set scope for HTTP request", e);
        }
    }

    @NotNull
    private HttpServletRequest resolveHttpServletRequest(@NotNull HttpServletRequest request) {
        if (this.hub.getOptions().isSendDefaultPii() && this.qualifiesForCaching(request, this.hub.getOptions().getMaxRequestBodySize())) {
            try {
                return new CachedBodyHttpServletRequest(request);
            }
            catch (IOException e) {
                this.hub.getOptions().getLogger().log(SentryLevel.WARNING, "Failed to cache HTTP request body. Request body will not be attached to Sentry events.", (Throwable)e);
                return request;
            }
        }
        return request;
    }

    private boolean qualifiesForCaching(@NotNull HttpServletRequest request, @NotNull SentryOptions.RequestSize maxRequestBodySize) {
        int contentLength = request.getContentLength();
        String contentType = request.getContentType();
        return maxRequestBodySize != SentryOptions.RequestSize.NONE && contentLength != -1 && contentType != null && MimeType.valueOf((String)contentType).isCompatibleWith((MimeType)MediaType.APPLICATION_JSON) && (maxRequestBodySize == SentryOptions.RequestSize.SMALL && contentLength < 1000 || maxRequestBodySize == SentryOptions.RequestSize.MEDIUM && contentLength < 10000 || maxRequestBodySize == SentryOptions.RequestSize.ALWAYS);
    }

    static final class RequestBodyExtractingEventProcessor
    implements EventProcessor {
        @NotNull
        private final RequestPayloadExtractor requestPayloadExtractor = new RequestPayloadExtractor();
        @NotNull
        private final HttpServletRequest request;
        @NotNull
        private final SentryOptions options;

        public RequestBodyExtractingEventProcessor(@NotNull HttpServletRequest request, @NotNull SentryOptions options) {
            this.request = (HttpServletRequest)Objects.requireNonNull((Object)request, (String)"request is required");
            this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options is required");
        }

        @NotNull
        public SentryEvent process(@NotNull SentryEvent event, @Nullable Map<String, Object> hint) {
            if (event.getRequest() != null) {
                event.getRequest().setData((Object)this.requestPayloadExtractor.extract(this.request, this.options));
            }
            return event;
        }
    }
}

