/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.webflux;

import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.NoOpHub;
import io.sentry.Sentry;
import io.sentry.spring.webflux.SentryRequestResolver;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@ApiStatus.Experimental
public final class SentryWebFilter
implements WebFilter {
    @NotNull
    private final SentryRequestResolver sentryRequestResolver;

    public SentryWebFilter(@NotNull IHub hub) {
        Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.sentryRequestResolver = new SentryRequestResolver(hub);
    }

    public Mono<Void> filter(@NotNull ServerWebExchange serverWebExchange, @NotNull WebFilterChain webFilterChain) {
        @NotNull IHub requestHub = Sentry.cloneMainHub();
        return webFilterChain.filter(serverWebExchange).doFinally(__ -> {
            requestHub.popScope();
            Sentry.setCurrentHub((IHub)NoOpHub.getInstance());
        }).doFirst(() -> {
            Sentry.setCurrentHub((IHub)requestHub);
            requestHub.pushScope();
            @NotNull ServerHttpRequest request = serverWebExchange.getRequest();
            ServerHttpResponse response = serverWebExchange.getResponse();
            Hint hint = new Hint();
            hint.set("webFluxFilter:request", (Object)request);
            hint.set("webFluxFilter:response", (Object)response);
            String methodName = request.getMethod() != null ? request.getMethod().name() : "unknown";
            requestHub.addBreadcrumb(Breadcrumb.http((String)request.getURI().toString(), (String)methodName), hint);
            requestHub.configureScope(scope -> scope.setRequest(this.sentryRequestResolver.resolveSentryRequest(request)));
        });
    }
}

