/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.Baggage;
import io.sentry.CustomSamplingContext;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.ITransaction;
import io.sentry.SentryLevel;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.exception.InvalidSentryTraceHeaderException;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.tracing.SpringMvcTransactionNameProvider;
import io.sentry.spring.tracing.TransactionNameProvider;
import io.sentry.util.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class SentryTracingFilter
extends OncePerRequestFilter {
    private static final String TRANSACTION_OP = "http.server";
    @NotNull
    private final TransactionNameProvider transactionNameProvider;
    @NotNull
    private final IHub hub;

    public SentryTracingFilter() {
        this((IHub)HubAdapter.getInstance());
    }

    public SentryTracingFilter(@NotNull IHub hub, @NotNull TransactionNameProvider transactionNameProvider) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.transactionNameProvider = (TransactionNameProvider)Objects.requireNonNull((Object)transactionNameProvider, (String)"transactionNameProvider is required");
    }

    public SentryTracingFilter(@NotNull IHub hub) {
        this(hub, new SpringMvcTransactionNameProvider());
    }

    protected void doFilterInternal(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse, @NotNull FilterChain filterChain) throws ServletException, IOException {
        if (this.hub.isEnabled() && this.shouldTraceRequest(httpRequest)) {
            String sentryTraceHeader = httpRequest.getHeader("sentry-trace");
            ArrayList<String> baggageHeader = Collections.list(httpRequest.getHeaders("baggage"));
            ITransaction transaction = this.startTransaction(httpRequest, sentryTraceHeader, baggageHeader);
            try {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (Throwable e) {
                transaction.setStatus(SpanStatus.INTERNAL_ERROR);
                throw e;
            }
            finally {
                String transactionName = this.transactionNameProvider.provideTransactionName(httpRequest);
                TransactionNameSource transactionNameSource = this.transactionNameProvider.provideTransactionSource();
                if (transactionName != null) {
                    transaction.setName(transactionName, transactionNameSource);
                    transaction.setOperation(TRANSACTION_OP);
                    if (transaction.getStatus() == null) {
                        transaction.setStatus(SpanStatus.fromHttpStatusCode((int)httpResponse.getStatus()));
                    }
                    transaction.finish();
                }
            }
        } else {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    private boolean shouldTraceRequest(@NotNull HttpServletRequest request) {
        return this.hub.getOptions().isTraceOptionsRequests() || !HttpMethod.OPTIONS.name().equals(request.getMethod());
    }

    private ITransaction startTransaction(@NotNull HttpServletRequest request, @Nullable String sentryTraceHeader, @Nullable List<String> baggageHeader) {
        String name = request.getMethod() + " " + request.getRequestURI();
        CustomSamplingContext customSamplingContext = new CustomSamplingContext();
        customSamplingContext.set("request", (Object)request);
        Baggage baggage = Baggage.fromHeader(baggageHeader, (ILogger)this.hub.getOptions().getLogger());
        if (sentryTraceHeader != null) {
            try {
                TransactionContext contexts = TransactionContext.fromSentryTrace((String)name, (TransactionNameSource)TransactionNameSource.URL, (String)TRANSACTION_OP, (SentryTraceHeader)new SentryTraceHeader(sentryTraceHeader), (Baggage)baggage, null);
                TransactionOptions transactionOptions = new TransactionOptions();
                transactionOptions.setCustomSamplingContext(customSamplingContext);
                transactionOptions.setBindToScope(true);
                return this.hub.startTransaction(contexts, transactionOptions);
            }
            catch (InvalidSentryTraceHeaderException e) {
                this.hub.getOptions().getLogger().log(SentryLevel.DEBUG, (Throwable)e, "Failed to parse Sentry trace header: %s", new Object[]{e.getMessage()});
            }
        }
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setCustomSamplingContext(customSamplingContext);
        transactionOptions.setBindToScope(true);
        return this.hub.startTransaction(new TransactionContext(name, TransactionNameSource.URL, TRANSACTION_OP), transactionOptions);
    }
}

